//
// Copyright (c) Bill Tracey KD5TFD  2006 (bill@ewjt.com) Phil Harman 2007 VK6APH (pvharman@arach.net.au)
//				 Scott Cowling WA2DFI 2008 (scotty@tonks.com)
//
// Production test program for the Penny FPGA -- 
// Validate as many PCB connections as possible.

// Select either the 10MHz or 125MHz clock source.

// WARNING: This code stimulates many FPGA pins that drive the Atlas bus. DO not plug in ANY
// other boards while running this test. 

// There are 100 I/O pins defined

// 19 Apr 2008	Scott Cowling	Import code from Ozy WrapTest.v and modify for Penelope production test
// 02 May 2008  Scott Cowling	Add encoding to error LED output to identify loopback failures								
//

module Penny_Prod_Test(

// (3) clock and clock control
   	input  CK_122MHZ,		// (132) 122.88MHz clock input
	input  CK_10MHZ,		// (131) 10MHz clock input
	output FPGA_PLL,	// (197) 122.88MHz PLL control output

// (22) Atlas bus pins, A row
	output A2,			// (133)
	output A3,			// (127)
	output A4,			// (117)
	output A5,			// (115)
	output A6,			// (113)
	output A7,			// (110)
	output A8,			// (105)
	output A9,			// (103)
	output A10,			// (101)
	output A11,			// (97)
	output A12,			// (95)
	output A13,			// (92)
	output A14,			// (89)
	output A15,			// (87)
	output A16,			// (84)
	output A17,			// (81)
	output A18,			// (77)
	output A19,			// (75)
	output A20,  		// (72) I2CSCK
	output A21,  		// (69) I2CSDA
	output A22,			// (67)
	output A31,			// (57)

// (27) Atlas bus pins, C row
	input C2,			// (128)
	input C3,			// (118)
	input C4,			// (116)
	input C5,			// (114)
	input C6,			// (112)
	input C7,			// (106)
	input C8,			// (104)
	input C9,			// (102)
	input C10,			// (99)
	input C11,			// (96)
	input C12,			// (94)
	input C13,			// (90)
	input C14,			// (88)
	input C15,			// (86)
	input C16,			// (82)
	input C17,			// (80)
	input C18,			// (76)
	input C19,			// (74)
	input C20,			// (70)
	input C21,			// (68)
	input C22,			// (64)
	input C31,			// (56)


// These outputs loop back to JTAG i/o and may not be testable
//
	output 	C23,		// (63) loops back to A23 (TMS) - keep high
	output 	C24,		// (61) loops back to A24 (TCK)
	input 	C29,		// (58) loops back to A29 (TDI)
	output 	C25,		// (60) loops back to A25 (SDOBACK)
	input 	C27,		// (59) loops back to A27 (TDO)


// (6) LED outputs, active low to light
	output LED2,		// (208)
	output LED3,		// (206)
	output LED4,		// (205)
	output LED5,		// (203)
	output LED6,		// (107)
	output LED7,		// (108)

// (2) PTT
	output FPGA_PTT,	// (134) PTT to DB25
	input  PTT,			// (171) active low PTT input from J4/JP4

// (7) Digital outputs inverted and buffered to DB25
	output USROUT0,		// (143)
	output USROUT1,		// (142)
	output USROUT2,		// (141)
	output USROUT3,		// (139)
	output USROUT4,		// (138)
	output USROUT5,		// (137)
	output USROUT6,		// (135)

// (14) DAC interface
	output DACD0,		// (173) DAC Data lines
	output DACD1,		// (175)
	output DACD2,		// (176)
	output DACD3,		// (179)
	output DACD4,		// (180)
	output DACD5, 		// (181)
	output DACD6, 		// (182)
	output DACD7,		// (185)
	output DACD8,		// (187)
	output DACD9,		// (188)
	output DACD10,		// (189)
	output DACD11,		// (191)
	output DACD12,		// (192)
	output DACD13,		// (193)

// (10) Codec interface
	output MOSI,		// (168)
	output SSCK,		// (165)
	output nCS, 		// (170)
	output CMODE,		// (169)
	output CDIN,		// (162)
	input  CDOUT,		// (160)
	output CBCLK,		// (163)
	output CLRCIN,		// (161)
	output CLRCOUT,		// (152)
	output CMCLK,		// (164)

// (4) DC interface
	output ADCMOSI,		// (147)
	output ADCCLK,		// (145)
	input  ADCMISO,		// (146)
	output nADCCS,		// (144)

// (3) PWM Outputs to buffers, non-inverting
	output PWM0,		// (149)
	output PWM1,		// (150)
	output PWM2,		// (151)

// (2) External LVDS clock control
	output nLVDSRXE,	// (200) active low enable external 122.88MHz clock from LVDS header
	output LVDSTXE,		// (199) active high enable drive 122.88MHz onto LVDS header

// (28) Unused pins
	output DRVR,		// (3) **NOT USED**
	output NU4,			// (4) **NOT USED**
	output NU5,			// (5) **NOT USED**
	output NU6,			// (6) **NOT USED**
	output NU8,			// (8) **NOT USED**
	output NU10,		// (10) **NOT USED**
	output NU11,		// (11) **NOT USED**
	output NU12,		// (12) **NOT USED**
	output NU13,		// (13) **NOT USED**
	output NU14,		// (14) **NOT USED**
	output NU15,		// (15) **NOT USED**
	output NU30,		// (30) **NOT USED**
	output NU31,		// (31) **NOT USED**
	output NU33,		// (33) **NOT USED**
	output NU34,		// (34) **NOT USED**
	output NU35,		// (35) **NOT USED**
	output NU37,		// (37) **NOT USED**
	output NU39,		// (39) **NOT USED**
	output NU40,		// (40) **NOT USED**
	output NU41,		// (41) **NOT USED**
	output NU43,		// (43) **NOT USED**
	output NU44,		// (44) **NOT USED**
	output NU45,		// (45) **NOT USED**
	output NU46,		// (46) **NOT USED**
	output DACCLK,		// (195) **NOT USED** (sourced directly from 122.88MHz)
	output LVDSCLK,		// (198) **NOT USED**
	output NU201,		// (201) **NOT USED**
	output NU207		// (207) **NOT USED**
		);

// divided down clock signals using 125MHz clock
// These are the frequencies of bits in the clk_reg register
// Note that these are based on a 125MHz input clock when we
// actually use 122.88MHz. Just too lazy to re-calculate...
        // 0 62.5MHz
        // 1 31.25MHz
        // 2 15.625MHz
        // 3 7.8MHz
        // 4 3.9MHz
        // 5 1.9MHz
        // 6 976kHz
        // 7 488kHz
        // 8 244kHz
        // 9 122kHz
        // 10 61kHz
        // 11 30.5kHz
        // 12 15.25kHz
        // 13  7.63kHz
        // 14  3.8kHz
        // 15  1.9kHz
        // 16  953Hz
        // 17  477Hz
        // 18  238Hz
		// 19  119Hz
		// 20   59Hz
		// 21   29Hz
		// 22   14Hz
		// 23    7Hz
		// 24   3.5Hz
		// 25   1.8Hz
		// 26     1Hz
		// 27   0.5Hz




// count the clock_reg counter up at 122.88MHz
//
reg [27:0] clock_reg;

always @ ( posedge  CK_122MHZ ) begin
// always @ ( posedge CK_10MHZ ) begin
   clock_reg <= clock_reg + 1'b1;
end


// divide 122.88MHz clock by 768 to get 160kHz on osc_12288
//
reg [10:0] count_12288; 	// counts up at 122.88MHz rate
reg osc_12288; 				// toggles at 160kHz rate

always @ ( posedge CK_122MHZ ) begin 
	if ( count_12288 == 767 ) begin 
		count_12288 <= 0; 
		osc_12288 <= ~ osc_12288; 
	end 
	else begin 
		count_12288 <= count_12288 + 1'd1; 
	end 
end 




/*
Test matrix

loopback				Penny		Penny		sch				sch
result			test	conn		conn		signal			signal
bit				nr		output		input		output			input
--------		----	-------		-------		---------		---------
0				0x00	P1-A25		P1-C25		ATLAS_A25		ATLAS_C25
1				0x01	P1-A24		P1-C24		ATLAS_A24		ATLAS_C24
2				0x02	P1-A23		P1-C23		ATLAS_A23		ATLAS_C23

3				0x03	P1-A22		P1-C22		ATLAS_A22		ATLAS_C22
4				0x04	P1-A19		P1-C19		ATLAS_A19		ATLAS_C19
5				0x05	P1-A18		P1-C18		ATLAS_A18		ATLAS_C18
6				0x06	P1-A17		P1-C17		ATLAS_A17		ATLAS_C17
7				0x07	P1-A16		P1-C16		ATLAS_A16		ATLAS_C16
8				0x08	P1-A15		P1-C15		ATLAS_A15		ATLAS_C15
9				0x09	P1-A14		P1-C14		ATLAS_A14		ATLAS_C14
10				0x0a	P1-A13		P1-C13		ATLAS_A13		ATLAS_C13
11				0x0b	P1-A12		P1-C12		ATLAS_A12		ATLAS_C12
12				0x0c	P1-A11		P1-C11		ATLAS_A11		ATLAS_C11
13				0x0d	P1-A10		P1-C10		ATLAS_A10		ATLAS_C10
14				0x0e	P1-A09		P1-C09		ATLAS_A9		ATLAS_C9
15				0x0f	P1-A08		P1-C08		ATLAS_A8		ATLAS_C8
16				0x10	P1-A07		P1-C07		ATLAS_A7		ATLAS_C7
17				0x11	P1-A06		P1-C06		ATLAS_A6		ATLAS_C6
18				0x12	P1-A05		P1-C05		ATLAS_A5		ATLAS_C5
19				0x13	P1-A04		P1-C04		ATLAS_A4		ATLAS_C4
20				0x14	P1-A03		P1-C03		ATLAS_A3		ATLAS_C3
21				0x15	P1-A02		J31-C02		ATLAS_A2		ATLAS_C2

22				0x16	J20-2		J20-10		FPGA_GPIO1		FPGA_GPIO17

23				0x17	P1-A20		P1-C20		FPGA_GPIO2		ATLAS_C20
24				0x18	P1-A21		P1-C21		FPGA_GPIO3		ATLAS_C21

25				0x19	J20-5		P1-A27		FPGA_GPIO4		ATLAS_A27
26				0x1a	J20-6		P1-A29		FPGA_GPIO5		ATLAS_A29
27				0x1b	J20-7		P1-A31		FPGA_GPIO6		ATLAS_A31
28				0x1c	J20-8		P1-C27		FPGA_GPIO7		ATLAS_C27
29				0x1d	J20-9		P1-C29		FPGA_GPIO8		ATLAS_C29
30				0x1e	J20-1		P1-C31		FPGA_GPIO9		ATLAS_C31
31				0x1f	J20-14		J20-11		FPGA_GPIO10		FPGA_GPIO18
32				0x20	J20-16		J20-12		FPGA_GPIO11		FPGA_GPIO19
33				0x21	J20-17		J20-13		FPGA_GPIO12		FPGA_GPIO20
34				0x22	J8-1		J20-15		FPGA_GPIO13		FPGA_GPIO21
25				0x23	J8-2		J8-6		FPGA_GPIO14		FPGA_GPIO22
36				0x24	J8-3		J8-7		FPGA_GPIO15		FPGA_GPIO23
37				0x25	J8-4		J8-8		FPGA_GPIO16		FPGA_GPIO24
*/




//-----------------------------------------------------------
//
// Define signal types for module pins
//

// stimulus outputs
/*
wire 		A2;		// hardware ATLAS_A2 (P1-A2)	
wire 		A3;		// hardware ATLAS_A3 (P1-A3)
wire 		A4;		// hardware ATLAS_A4 (P1-A4)
wire 		A5;		// hardware ATLAS_A5 (P1-A5)
wire 		A6;		// hardware ATLAS_A6 (P1-A6)
wire 		A7;		// hardware ATLAS_A7 (P1-A7)
wire 		A8;		// hardware ATLAS_A8 (P1-A8)
wire 		A9;		// hardware ATLAS_A9 (P1-A9)
wire 		A10;	// hardware ATLAS_A10 (P1-A10)
wire 		A11;	// hardware ATLAS_A11 (P1-A11)
wire 		A12;	// hardware ATLAS_A12 (P1-A12)
wire 		A13;	// hardware ATLAS_A13 (P1-A13)
wire 		A14;	// hardware ATLAS_A14 (P1-A14)
wire 		A15;	// hardware ATLAS_A15 (P1-A15)
wire 		A16;	// hardware ATLAS_A16 (P1-A16)
wire 		A17;	// hardware ATLAS_A17 (P1-A17)
wire 		A18;	// hardware ATLAS_A18 (P1-A18)
wire 		A19;	// hardware ATLAS_A19 (P1-A19)
wire 		A20;	// hardware ATLAS_A18 (P1-A20)
wire 		A21;	// hardware ATLAS_A19 (P1-A21)
wire 		A22;	// hardware ATLAS_A22 (P1-A22)
wire 		A31;	// hardware ATLAS_A23 (P1-A31)

wire		A23;	// hardware ATLAS_A23 (P1-A23) (TMS - always high)
wire 		A24;	// hardware ATLAS_A24 (P1-A24) (TCK)
wire 		A25;	// hardware ATLAS_A25 (P1-A25) (SDOBACK)


*/

//-----------------------------------------------------------
//
// Local signal declarations
//

//
//
//wire [15:0]	GPout;					// GPIO outputs

// LED control
//
reg [5:0] 	leds; 					// LEDs 1=off, 0=on
reg [24:0] 	clock_count; 			// counter for delaying LED rotation


// State machine
/*
reg [7:0]	test_circ_idx;			// index into pass and reset vectors (0 to 37)
reg [4:0] 	test_loop_state; 		// state bits
reg [4:0] 	post_xmit_state; 		// next state after transmit
reg [32:0] 	idle_counter; 			// counter for delay after each output line
reg [7:0] 	char_to_xmit; 			// output character register
reg [15:0] 	rs232_delay_count; 		// counter for delay after each output character
reg [7:0] 	pass_count; 			// number of circuits that pass on each scan (0 to 38)
*/
// Vectors for stimulus outputs
//
reg [23:0]	atlas_vec;			// vector for atlas stimulus outputs
//reg [15:0]	gpio_vec;			// vector for gpio stimulus outputs

// Vectors for response inputs
//
wire [23:0]	atlas_resp;			// vector for atlas response inputs
//wire [15:0]	gpio_resp;			// vector for gpio response inputs

// Loopback vectors
//
wire [23:0]	loopback_reset; 	// 1=reset loopback bit, 0=do nothing
reg [23:0]	loopback_result; 	// 1=error, 0=OK

// Loopback test signals
//
reg	[7:0] 	cmp_cnt;			// used to determine interval for pattern shifting

// Baud clock generator
//
//reg[16:0] baud_reg; 			// counter used to generate baud rate clock



//-----------------------------------------------------------
//

// invert led vector onto LED output pins	
//
// LED2 is the leftmost (MSB) and LED7 is the rightmost (LSB)
//
//	assign LED2 = ~leds[5]; 		
	assign LED2 = clock_reg[23];
	assign LED3 = ~leds[4];
	assign LED4 = ~leds[3]; 		
	assign LED5 = ~leds[2];
	assign LED6 = ~leds[1]; 		
	assign LED7 = ~leds[0];

// Unused output pins are set low
//
	assign	DRVR	= 1'b0;
	assign	NU4	 	= 1'b0;
	assign	NU5 	= 1'b0;
	assign	NU6 	= 1'b0;
	assign	NU8 	= 1'b0;
	assign	NU10 	= 1'b0;
	assign	NU11 	= 1'b0;
	assign	NU12 	= 1'b0;
	assign	NU13 	= 1'b0;
	assign	NU14 	= 1'b0;
	assign	NU15 	= 1'b0;
	assign	NU30 	= 1'b0;
	assign	NU31 	= 1'b0;
	assign	NU33 	= 1'b0;
	assign	NU34 	= 1'b0;
	assign	NU35 	= 1'b0;
	assign	NU37 	= 1'b0;
	assign	NU39 	= 1'b0;
	assign	NU40 	= 1'b0;
	assign	NU41 	= 1'b0;
	assign	NU43 	= 1'b0;
	assign	NU44 	= 1'b0;
	assign	NU45 	= 1'b0;
	assign	NU46 	= 1'b0;
	assign	DACCLK 	= 1'b0;
	assign	LVDSCLK = 1'b0;
	assign	NU201 	= 1'b0;
	assign	NU207 	= 1'b0;

// DAC outputs are tested with RF output test
	assign 	DACD0 	= 1'b0;
	assign 	DACD1 	= 1'b0;
	assign 	DACD2 	= 1'b0;
	assign 	DACD3 	= 1'b0;
	assign 	DACD4 	= 1'b0;
	assign 	DACD5 	= 1'b0;
	assign 	DACD6 	= 1'b0;
	assign 	DACD7 	= 1'b0;
	assign 	DACD8 	= 1'b0;
	assign 	DACD9 	= 1'b0;
	assign 	DACD10 	= 1'b0;
	assign 	DACD11 	= 1'b0;
	assign 	DACD12 	= 1'b0;
	assign 	DACD13 	= 1'b0;

// assign CODEC outputs all low - these will be tested  with the RF output test
	assign 	MOSI 	= 1'bz;		// keep hi-z to avoid conflict with test on A21 (I2CSDA) when jumper is on
	assign 	SSCK 	= 1'bz;		// keep hi-z to avoid conflict with test on A20 (I2CSCK) when jumper is on
	assign 	nCS 	= 1'b1;
	assign 	CMODE 	= 1'b0;
	assign 	CDIN 	= 1'b0;
	assign 	CBCLK 	= 1'b0;
	assign 	CLRCIN 	= 1'b0;
	assign 	CLRCOUT = 1'b0;
	assign 	CMCLK 	= 1'b0;

// assign LVDS driver enables to inactive
//
	assign nLVDSRXE = 1'b1;
	assign LVDSTXE = 1'b0;

// assign unused bus pins high - these connect to JTAG, will use in the future
//
	assign	C23 = 1'b1;		// TMS - keep high

// set VCO control high
//
	assign	FPGA_PLL = 1'b1;



// Assign stimulus output vector bits to output pins
//
assign A2 = atlas_vec[0];
assign A3 = atlas_vec[1];
assign A4 = atlas_vec[2];
assign A5 = atlas_vec[3];
assign A6 = atlas_vec[4];
assign A7 = atlas_vec[5];
assign A8 = atlas_vec[6];
assign A9 = atlas_vec[7];
assign A10 = atlas_vec[8];
assign A11 = atlas_vec[9];
assign A12 = atlas_vec[10];
assign A13 = atlas_vec[11];
assign A14 = atlas_vec[12];
assign A15 = atlas_vec[13];
assign A16 = atlas_vec[14];
assign A17 = atlas_vec[15];
assign A18 = atlas_vec[16];
assign A19 = atlas_vec[17];
assign A20 = atlas_vec[18];
assign A21 = atlas_vec[19];
assign A22 = atlas_vec[20];
assign A31 = atlas_vec[21];
assign C24 = atlas_vec[22];
assign C25 = atlas_vec[23];

// Assign input pins to response vector
//
assign atlas_resp = {C27,		// hardware ATLAS_C27 (P1-C27)
					C29,		// hardware ATLAS_C29 (P1_C29)
					C31,		// hardware ATLAS_C31 (P1-C31)
					C22,		// hardware ATLAS_C22 (P1-C3)
					C21,		// hardware ATLAS_C21 (P1-C4)
					C20,		// hardware ATLAS_C20 (P1-C5)
					C19,		// hardware ATLAS_C19 (P1-C6)
					C18,		// hardware ATLAS_C18 (P1-C7)
					C17,		// hardware ATLAS_C17 (P1-C8)
					C16,		// hardware ATLAS_C16 (P1-C9)
					C15,		// hardware ATLAS_C15 (P1-C10)
					C14,		// hardware ATLAS_C14 (P1-C11)
					C13,		// hardware ATLAS_C13 (P1-C12)
					C12,		// hardware ATLAS_C12 (P1-C13)
					C11,		// hardware ATLAS_C11 (P1-C14)
					C10,		// hardware ATLAS_C10 (P1-C15)
					C9,			// hardware ATLAS_C9 (P1-C16)
					C8,			// hardware ATLAS_C8 (P1-C17)
					C7,			// hardware ATLAS_C7 (P1-C18)
					C6,			// hardware ATLAS_C6 (P1-C19)
					C5,			// hardware ATLAS_C5 (P1-C22)
					C4,			// hardware ATLAS_C4 (P1-C23)
					C3,			// hardware ATLAS_C3 (P1-C24)
					C2};		// hardware ATLAS_C2 (P1-C25)
					

//-----------------------------------------------------------
//
// Generate test pattern on Atlas vectors.
//

assign	loopback_reset = 24'h0;

always @ (posedge CK_10MHZ) begin
	if (clock_count == 25'h0) begin
		atlas_vec	<= 24'h555555;		// clear both vectors
		cmp_cnt		<= 8'h0;			// clear delay count
		loopback_result	<= 24'h0;		// clear errors
	end
	else begin 
		if (cmp_cnt	== 8'h10) begin				// time to update loopback_result
			loopback_result	<= ((atlas_vec ^ atlas_resp) | loopback_result) & (~loopback_reset);
		end

		if (cmp_cnt == 8'h20) begin				// time to change stimulus
			cmp_cnt			<= 8'h0;			// and restart delay count
//			loopback_result	<= loopback_result & (~loopback_reset);		// clear errors if required		
			if (atlas_vec == 24'h0) begin
				atlas_vec	<= 24'h555555;		// if rotation complete, start with initial pattern
			end
			else begin
				atlas_vec	<= atlas_vec << 1;	// shift left
			end
		end
		else begin
			cmp_cnt			<= cmp_cnt + 8'b1;				// increment count
		end
	end
end 


//
// LED rotation generator
//
// Five LEDs rotate unless an error is detected in the loopback result
// register. When error is detected, they hold all on.

always @ (posedge CK_10MHZ) begin 
	if ( clock_count == 25'd1200000 ) begin
		clock_count <= 25'd0; 
		if (|loopback_result[23:0] || |in1_err[3:0] || |in2_err[3:0] || |in3_err[3:0] || |in4_err[5:0]) begin

// encode failure group onto LEDs
//
			leds[0] <= |loopback_result[23:0]; 	// LED0 = Atlas bus loopback
			leds[1]	<= |in1_err[3:0];			// LED1 = AIN1, OC0, OC4, PWM0
			leds[2]	<= |in2_err[3:0];			// LED2 = AIN2, OC1, OC5, PWM1
			leds[3]	<= |in3_err[3:0];			// LED3 = AIN3, OC2, OC6, PWM2
			leds[4]	<= |in4_err[3:0];			// LED4 = AIN4, OC3, PTT_OUT, PTT_IN
		end

		else if ( (leds[4] == 1'b1) || (leds[4:0] == 5'b0) ) begin 		// no error, msb high or all bits zero so set init pattern
			leds[4:0] 	<= 5'b00001; 
		end

		else begin 								// no error, msb clear so shift
			leds[4:0]	<= leds[4:0] << 1; 
		end
	end
			
	else begin 
		clock_count <= clock_count + 25'h1; 
	end
end 



//////////////////////////////////////////////////////////////
//
//		ADC SPI interface 
//
//////////////////////////////////////////////////////////////


wire [11:0]AIN1;  // holds 12 bit ADC value of AIN1.
wire [11:0]AIN2;  // holds 12 bit ADC value of AIN2.
wire [11:0]AIN3;  // holds 12 bit ADC value of AIN3.
wire [11:0]AIN4;  // holds 12 bit ADC value of AIN4.
wire [11:0]AIN5;  // holds 12 bit ADC value of Forward Power detector (AIN5).

ADC ADC_SPI(.clock(CK_10MHZ), .SCLK(ADCCLK), .nADCCS(nADCCS), .MISO(ADCMISO), .MOSI(ADCMOSI), 
			.AIN1(AIN1), .AIN2(AIN2), .AIN3(AIN3), .AIN4(AIN4), .AIN5(AIN5));





//////////////////////////////////////////////////////////////
//
//		IN1 loopback test 
//
//////////////////////////////////////////////////////////////

// Here we stimulate IN1 with USROUT0, USROUT4 and PWM0
//
// Note: it takes 320 CK_10MHZ clocks to read all of the ADC channels

reg	[3:0]in1_err;		// error flags 1=error
reg	[1:0]in1_state;		// state counter

reg	PWM0_out;				// PWM drive output
reg	USROUT0_out;			// OC driver output
reg	USROUT4_out;			// OC driver output

assign PWM0 = PWM0_out;
assign USROUT0 = USROUT0_out;
assign USROUT4 = USROUT4_out;

//reg [5:0]led_test;
//assign leds[5:4] = 2'b0;
//assign leds[3:0] = in1_err[3:0];

always @ (posedge CK_10MHZ) begin
	case (in1_state)
		0: begin
			PWM0_out 	<= 0;
			USROUT0_out	<= 0;
			USROUT4_out	<= 0;
			if (clock_count == 16'h2000) begin
				in1_state <= 1;
				in1_err[0] <= |AIN1[11:7];	// five msb should be low for 0.0V no drive, set flag if not
//				led_test[5:0] <= AIN1[11:6];
			end
			else begin
				in1_state <= 0;
			end
		end

		1: begin
			PWM0_out 	<= 1;
			USROUT0_out	<= 1;
			USROUT4_out	<= 0;
			if (clock_count == 16'h4000) begin
				in1_state <= 2;
				in1_err[1] <= |AIN1[11:10];	// two msb should be low for 0.0V PD, set flag if not
			end
			else begin
				in1_state <= 1;
			end
		end

		2: begin
			PWM0_out	<= 1;
			USROUT0_out	<= 0;
			USROUT4_out	<= 1;
			if (clock_count == 16'h6000) begin
				in1_state <= 3;
				in1_err[2] <= ~(&AIN1[11:9]);	// three msb should be high for 3.0V, set flag if not
			end
			else begin
				in1_state <= 2;
			end
		end

		3: begin
			PWM0_out 	<= 1;
			USROUT0_out	<= 0;
			USROUT4_out	<= 0;
			if (clock_count == 16'h8000) begin
				in1_state <= 0;
				in1_err[3] <= ~(&AIN1[11:7]);		// five msb should be high for 3.3V, set flag if not
			end
			else begin
				in1_state <= 3;
			end
		end

		default: begin
		end

	endcase
end




//////////////////////////////////////////////////////////////
//
//		IN2 loopback test 
//
//////////////////////////////////////////////////////////////

// Here we stimulate IN2 with USROUT1, USROUT5 and PWM1
//
// Note: it takes 320 CK_10MHZ clocks to read all of the ADC channels

reg	[3:0]in2_err;		// error flags 1=error
reg	[1:0]in2_state;		// state counter

reg	PWM1_out;				// PWM drive output
reg	USROUT1_out;			// OC driver output
reg	USROUT5_out;			// OC driver output

assign PWM1 = PWM1_out;
assign USROUT1 = USROUT1_out;
assign USROUT5 = USROUT5_out;

//reg [5:0]led_test;
//assign leds[5:4] = 2'b0;
//assign leds[3:0] = in1_err[3:0];

always @ (posedge CK_10MHZ) begin
	case (in2_state)
		0: begin
			PWM1_out 	<= 0;
			USROUT1_out	<= 0;
			USROUT5_out	<= 0;
			if (clock_count == 16'h2000) begin
				in2_state <= 1;
				in2_err[0] <= |AIN2[11:7];	// five msb should be low for 0.0V no drive, set flag if not
//				led_test[5:0] <= AIN2[11:6];
			end
			else begin
				in2_state <= 0;
			end
		end

		1: begin
			PWM1_out 	<= 1;
			USROUT1_out	<= 1;
			USROUT5_out	<= 0;
			if (clock_count == 16'h4000) begin
				in2_state <= 2;
				in2_err[1] <= |AIN2[11:10];	// two msb should be low for 0.0V PD, set flag if not
			end
			else begin
				in2_state <= 1;
			end
		end

		2: begin
			PWM1_out	<= 1;
			USROUT1_out	<= 0;
			USROUT5_out	<= 1;
			if (clock_count == 16'h6000) begin
				in2_state <= 3;
				in2_err[2] <= ~(&AIN2[11:10]);	// two msb should be high for 2.95V, set flag if not
			end
			else begin
				in2_state <= 2;
			end
		end

		3: begin
			PWM1_out 	<= 1;
			USROUT1_out	<= 0;
			USROUT5_out	<= 0;
			if (clock_count == 16'h8000) begin
				in2_state <= 0;
				in2_err[3] <= ~(&AIN2[11:7]);		// five msb should be high for 3.3V, set flag if not
			end
			else begin
				in2_state <= 3;
			end
		end

		default: begin
		end

	endcase
end


//////////////////////////////////////////////////////////////
//
//		IN3 loopback test 
//
//////////////////////////////////////////////////////////////

// Here we stimulate IN3 with USROUT2, USROUT6 and PWM2
//
// Note: it takes 320 CK_10MHZ clocks to read all of the ADC channels

reg	[3:0]in3_err;		// error flags 1=error
reg	[1:0]in3_state;		// state counter

reg	PWM2_out;				// PWM drive output
reg	USROUT2_out;			// OC driver output
reg	USROUT6_out;			// OC driver output

assign PWM2 = PWM2_out;
assign USROUT2 = USROUT2_out;
assign USROUT6 = USROUT6_out;

//reg [5:0]led_test;
//assign leds[5:4] = 2'b0;
//assign leds[3:0] = in1_err[3:0];

always @ (posedge CK_10MHZ) begin
	case (in3_state)
		0: begin
			PWM2_out 	<= 0;
			USROUT2_out	<= 0;
			USROUT6_out	<= 0;
			if (clock_count == 16'h2000) begin
				in3_state <= 1;
				in3_err[0] <= |AIN3[11:7];	// five msb should be low for 0.0V no drive, set flag if not
//				led_test[5:0] <= AIN3[11:6];
			end
			else begin
				in3_state <= 0;
			end
		end

		1: begin
			PWM2_out 	<= 1;
			USROUT2_out	<= 1;
			USROUT6_out	<= 0;
			if (clock_count == 16'h4000) begin
				in3_state <= 2;
				in3_err[1] <= |AIN3[11:10];	// two msb should be low for 0.0V PD, set flag if not
			end
			else begin
				in3_state <= 1;
			end
		end

		2: begin
			PWM2_out	<= 1;
			USROUT2_out	<= 0;
			USROUT6_out	<= 1;
			if (clock_count == 16'h6000) begin
				in3_state <= 3;
				in3_err[2] <= ~(&AIN3[11:10]);	// two msb should be high for 2.7V, set flag if not
			end
			else begin
				in3_state <= 2;
			end
		end

		3: begin
			PWM2_out 	<= 1;
			USROUT2_out	<= 0;
			USROUT6_out	<= 0;
			if (clock_count == 16'h8000) begin
				in3_state <= 0;
				in3_err[3] <= ~(&AIN3[11:7]);		// five msb should be high for 3.3V, set flag if not
			end
			else begin
				in3_state <= 3;
			end
		end

		default: begin
		end

	endcase
end



//////////////////////////////////////////////////////////////
//
//		IN4 loopback test 
//
//////////////////////////////////////////////////////////////

// Here we stimulate IN3 with USROUT2, USROUT6 and PWM2
//
// Note: it takes 320 CK_10MHZ clocks to read all of the ADC channels

reg	[5:0]in4_err;		// error flags 1=error
reg	[1:0]in4_state;		// state counter

reg	USROUT3_out;			// OC driver output
reg	FPGA_PTT_out;			// OC driver output

assign USROUT3 = USROUT3_out;
assign FPGA_PTT = FPGA_PTT_out;

//reg [5:0]led_test;
//assign leds[5:4] = 2'b0;
//assign leds[3:0] = in1_err[3:0];

always @ (posedge CK_10MHZ) begin
	case (in4_state)
		0: begin
			USROUT3_out		<= 1;
			FPGA_PTT_out	<= 0;
			if (clock_count == 16'h2000) begin
				in4_state <= 1;
				in4_err[0] <= |AIN4[11:10];	// two msb should be low for 0.0V with pu, set flag if not
				in4_err[1] <= PTT;			// if PTT high, error
			end
			else begin
				in4_state <= 0;
			end
		end

		1: begin
			USROUT3_out		<= 0;
			FPGA_PTT_out	<= 1;
			if (clock_count == 16'h4000) begin
				in4_state <= 2;
				in4_err[2] <= |AIN3[11:10];			// two msb should be low for 0.0V with pu, set flag if not
				in4_err[3] <= PTT;					// if PTT high, error
//				led_test[5:0] <= AIN4[11:6];
			end
			else begin
				in4_state <= 1;
			end
		end

		2: begin
			USROUT3_out		<= 0;
			FPGA_PTT_out	<= 0;
			if (clock_count == 16'h6000) begin
				in4_state <= 0;
				in4_err[4] <= ~(&AIN4[11:7]);	// five msb should be high for 3.3V, set flag if not
				in4_err[5] <= ~PTT;				// if PTT low, error
			end
			else begin
				in4_state <= 2;
			end
		end

		3: begin
			in4_state <= 0;
		end

		default: begin
		end

	endcase
end


endmodule 