// -------------------------------------------------------------
//
// Module: cic_8_1_5_nofraction
//
// Generated by MATLAB(R) 7.2 and the Filter Design HDL Coder 1.4.
//
// Generated on: 2007-05-24 16:17:33
//
// -------------------------------------------------------------

// -------------------------------------------------------------
// HDL Code Generation Options:
//
// TargetLanguage: Verilog
// Name: cic_8_1_5_nofraction
// TargetDirectory: c:\HPSDR\trunk\VK6APH\Mercury\Matlab-files
// FIRAdderStyle: tree
// CoeffMultipliers: csd
// SerialPartition: -1
// AddPipelineRegisters: On
// CastBeforeSum: On
//
// Filter Settings:
//
// Discrete-Time FIR Multirate Filter (real)
// -----------------------------------------
// Filter Structure        : Cascaded Integrator-Comb Decimator
// Decimation Factor       : 8
// Differential Delay      : 1
// Number of Sections      : 5
// Stable                  : Yes
// Linear Phase            : Yes (Type 2)
//
// Input                   : s24,0
// Output                  : s24,-15
// Filter Internals        : Minimum Word Lengths
//   Integrator Section 1  : s39,0
//   Integrator Section 2  : s36,-3
//   Integrator Section 3  : s34,-5
//   Integrator Section 4  : s32,-7
//   Integrator Section 5  : s31,-8
//   Comb Section 1        : s30,-9
//   Comb Section 2        : s29,-10
//   Comb Section 3        : s28,-11
//   Comb Section 4        : s27,-12
//   Comb Section 5        : s27,-12
//
// Implementation Cost
// Number of Multipliers : 0
// Number of Adders      : 10
// Number of States      : 10
// MultPerInputSample    : 0
// AddPerInputSample     : 5.625
// -------------------------------------------------------------

`timescale 1 ns / 1 ns

module cic_8_1_5_nofraction 
               (
                clk,
                clk_enable,
                reset,
                filter_in,
                filter_out,
                ce_out
                );

  input   clk; 
  input   clk_enable; 
  input   reset; 
  input   signed [23:0] filter_in; //sfix24
  output  signed [23:0] filter_out; //sfix24_E15
  output  ce_out; 

////////////////////////////////////////////////////////////////
//Module Architecture: cic_8_1_5_nofraction
////////////////////////////////////////////////////////////////
  // Local Functions
  // Type Definitions
  // Constants
  // Signals
  reg  [2:0] cur_count; // ufix3
  wire phase_1; // boolean
  wire ce_delayline; // boolean
  reg  int_delay_pipe [0:3] ; // boolean
  wire ce_gated; // boolean
  reg  ce_out_reg; // boolean
  //   
  reg  signed [23:0] input_register; // sfix24
  //   -- Section 1 Signals 
  wire signed [23:0] section_in1; // sfix24
  wire signed [38:0] section_cast1; // sfix39
  wire signed [38:0] sum1; // sfix39
  reg  signed [38:0] section_out1; // sfix39
  wire signed [38:0] add_cast; // sfix39
  wire signed [38:0] add_cast_1; // sfix39
  wire signed [39:0] add_temp; // sfix40
  //   -- Section 2 Signals 
  wire signed [38:0] section_in2; // sfix39
  wire signed [35:0] section_cast2; // sfix36_E3
  wire signed [35:0] sum2; // sfix36_E3
  reg  signed [35:0] section_out2; // sfix36_E3
  wire signed [35:0] add_cast_2; // sfix36_E3
  wire signed [35:0] add_cast_3; // sfix36_E3
  wire signed [36:0] add_temp_1; // sfix37_E3
  //   -- Section 3 Signals 
  wire signed [35:0] section_in3; // sfix36_E3
  wire signed [33:0] section_cast3; // sfix34_E5
  wire signed [33:0] sum3; // sfix34_E5
  reg  signed [33:0] section_out3; // sfix34_E5
  wire signed [33:0] add_cast_4; // sfix34_E5
  wire signed [33:0] add_cast_5; // sfix34_E5
  wire signed [34:0] add_temp_2; // sfix35_E5
  //   -- Section 4 Signals 
  wire signed [33:0] section_in4; // sfix34_E5
  wire signed [31:0] section_cast4; // sfix32_E7
  wire signed [31:0] sum4; // sfix32_E7
  reg  signed [31:0] section_out4; // sfix32_E7
  wire signed [31:0] add_cast_6; // sfix32_E7
  wire signed [31:0] add_cast_7; // sfix32_E7
  wire signed [32:0] add_temp_3; // sfix33_E7
  //   -- Section 5 Signals 
  wire signed [31:0] section_in5; // sfix32_E7
  wire signed [30:0] section_cast5; // sfix31_E8
  wire signed [30:0] sum5; // sfix31_E8
  reg  signed [30:0] section_out5; // sfix31_E8
  wire signed [30:0] add_cast_8; // sfix31_E8
  wire signed [30:0] add_cast_9; // sfix31_E8
  wire signed [31:0] add_temp_4; // sfix32_E8
  //   -- Section 6 Signals 
  wire signed [30:0] section_in6; // sfix31_E8
  wire signed [29:0] section_cast6; // sfix30_E9
  reg  signed [29:0] diff1; // sfix30_E9
  wire signed [29:0] section_out6; // sfix30_E9
  wire signed [29:0] sub_cast; // sfix30_E9
  wire signed [29:0] sub_cast_1; // sfix30_E9
  wire signed [30:0] sub_temp; // sfix31_E9
  reg  signed [29:0] cic_pipeline6; // sfix30_E9
  //   -- Section 7 Signals 
  wire signed [29:0] section_in7; // sfix30_E9
  wire signed [28:0] section_cast7; // sfix29_E10
  reg  signed [28:0] diff2; // sfix29_E10
  wire signed [28:0] section_out7; // sfix29_E10
  wire signed [28:0] sub_cast_2; // sfix29_E10
  wire signed [28:0] sub_cast_3; // sfix29_E10
  wire signed [29:0] sub_temp_1; // sfix30_E10
  reg  signed [28:0] cic_pipeline7; // sfix29_E10
  //   -- Section 8 Signals 
  wire signed [28:0] section_in8; // sfix29_E10
  wire signed [27:0] section_cast8; // sfix28_E11
  reg  signed [27:0] diff3; // sfix28_E11
  wire signed [27:0] section_out8; // sfix28_E11
  wire signed [27:0] sub_cast_4; // sfix28_E11
  wire signed [27:0] sub_cast_5; // sfix28_E11
  wire signed [28:0] sub_temp_2; // sfix29_E11
  reg  signed [27:0] cic_pipeline8; // sfix28_E11
  //   -- Section 9 Signals 
  wire signed [27:0] section_in9; // sfix28_E11
  wire signed [26:0] section_cast9; // sfix27_E12
  reg  signed [26:0] diff4; // sfix27_E12
  wire signed [26:0] section_out9; // sfix27_E12
  wire signed [26:0] sub_cast_6; // sfix27_E12
  wire signed [26:0] sub_cast_7; // sfix27_E12
  wire signed [27:0] sub_temp_3; // sfix28_E12
  reg  signed [26:0] cic_pipeline9; // sfix27_E12
  //   -- Section 10 Signals 
  wire signed [26:0] section_in10; // sfix27_E12
  reg  signed [26:0] diff5; // sfix27_E12
  wire signed [26:0] section_out10; // sfix27_E12
  wire signed [26:0] sub_cast_8; // sfix27_E12
  wire signed [26:0] sub_cast_9; // sfix27_E12
  wire signed [27:0] sub_temp_4; // sfix28_E12
  wire signed [23:0] output_typeconvert; // sfix24_E15
  //   
  reg  signed [23:0] output_register; // sfix24_E15

  // Block Statements
  //   ------------------ CE Output Generation ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output
      if (reset == 1'b1) begin
        cur_count <= 3'b000;
      end
      else begin
        if (clk_enable == 1'b1) begin
          if (cur_count == 3'b111) begin
            cur_count <= 3'b000;
          end
          else begin
            cur_count <= cur_count + 1;
          end
        end
      end
    end // ce_output

  assign  phase_1 = (cur_count == 3'b001 && clk_enable == 1'b1)? 1 : 0;

  always @( posedge clk or posedge reset)
    begin: ce_delay
      if (reset == 1'b1) begin
        int_delay_pipe[0] <= 1'b0;
        int_delay_pipe[1] <= 1'b0;
        int_delay_pipe[2] <= 1'b0;
        int_delay_pipe[3] <= 1'b0;
      end
      else begin
        if (phase_1 == 1'b1) begin
        int_delay_pipe[0] <= clk_enable;
        int_delay_pipe[1] <= int_delay_pipe[0];
        int_delay_pipe[2] <= int_delay_pipe[1];
        int_delay_pipe[3] <= int_delay_pipe[2];
        end
      end
    end // ce_delay

    assign ce_delayline = int_delay_pipe[3];
  assign ce_gated =  ce_delayline & phase_1;

  //   ------------------ CE Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output_register
      if (reset == 1'b1) begin
        ce_out_reg <= 1'b0;
      end
      else begin
          ce_out_reg <= ce_gated;
      end
    end // ce_output_register

  //   ------------------ Input Register ------------------

  always @ (posedge clk or posedge reset)
    begin: input_reg_process
      if (reset == 1'b1) begin
        input_register <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          input_register <= filter_in;
        end
      end
    end // input_reg_process

  //   ------------------ Section # 1 : Integrator ------------------

  assign section_in1 = input_register;

  assign section_cast1 = $signed({{15{section_in1[23]}}, section_in1});

  assign add_cast = section_cast1;
  assign add_cast_1 = section_out1;
  assign add_temp = add_cast + add_cast_1;
  assign sum1 = add_temp[38:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section1
      if (reset == 1'b1) begin
        section_out1 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out1 <= sum1;
        end
      end
    end // integrator_delay_section1

  //   ------------------ Section # 2 : Integrator ------------------

  assign section_in2 = section_out1;

  assign section_cast2 = section_in2[38:3];

  assign add_cast_2 = section_cast2;
  assign add_cast_3 = section_out2;
  assign add_temp_1 = add_cast_2 + add_cast_3;
  assign sum2 = add_temp_1[35:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section2
      if (reset == 1'b1) begin
        section_out2 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out2 <= sum2;
        end
      end
    end // integrator_delay_section2

  //   ------------------ Section # 3 : Integrator ------------------

  assign section_in3 = section_out2;

  assign section_cast3 = section_in3[35:2];

  assign add_cast_4 = section_cast3;
  assign add_cast_5 = section_out3;
  assign add_temp_2 = add_cast_4 + add_cast_5;
  assign sum3 = add_temp_2[33:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section3
      if (reset == 1'b1) begin
        section_out3 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out3 <= sum3;
        end
      end
    end // integrator_delay_section3

  //   ------------------ Section # 4 : Integrator ------------------

  assign section_in4 = section_out3;

  assign section_cast4 = section_in4[33:2];

  assign add_cast_6 = section_cast4;
  assign add_cast_7 = section_out4;
  assign add_temp_3 = add_cast_6 + add_cast_7;
  assign sum4 = add_temp_3[31:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section4
      if (reset == 1'b1) begin
        section_out4 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out4 <= sum4;
        end
      end
    end // integrator_delay_section4

  //   ------------------ Section # 5 : Integrator ------------------

  assign section_in5 = section_out4;

  assign section_cast5 = section_in5[31:1];

  assign add_cast_8 = section_cast5;
  assign add_cast_9 = section_out5;
  assign add_temp_4 = add_cast_8 + add_cast_9;
  assign sum5 = add_temp_4[30:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section5
      if (reset == 1'b1) begin
        section_out5 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out5 <= sum5;
        end
      end
    end // integrator_delay_section5

  //   ------------------ Section # 6 : Comb ------------------

  assign section_in6 = section_out5;

  assign section_cast6 = section_in6[30:1];

  assign sub_cast = section_cast6;
  assign sub_cast_1 = diff1;
  assign sub_temp = sub_cast - sub_cast_1;
  assign section_out6 = sub_temp[29:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section6
      if (reset == 1'b1) begin
        diff1 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff1 <= section_cast6;
        end
      end
    end // comb_delay_section6

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section6
      if (reset == 1'b1) begin
        cic_pipeline6 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline6 <= section_out6;
        end
      end
    end // cic_pipeline_process_section6

  //   ------------------ Section # 7 : Comb ------------------

  assign section_in7 = cic_pipeline6;

  assign section_cast7 = section_in7[29:1];

  assign sub_cast_2 = section_cast7;
  assign sub_cast_3 = diff2;
  assign sub_temp_1 = sub_cast_2 - sub_cast_3;
  assign section_out7 = sub_temp_1[28:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section7
      if (reset == 1'b1) begin
        diff2 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff2 <= section_cast7;
        end
      end
    end // comb_delay_section7

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section7
      if (reset == 1'b1) begin
        cic_pipeline7 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline7 <= section_out7;
        end
      end
    end // cic_pipeline_process_section7

  //   ------------------ Section # 8 : Comb ------------------

  assign section_in8 = cic_pipeline7;

  assign section_cast8 = section_in8[28:1];

  assign sub_cast_4 = section_cast8;
  assign sub_cast_5 = diff3;
  assign sub_temp_2 = sub_cast_4 - sub_cast_5;
  assign section_out8 = sub_temp_2[27:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section8
      if (reset == 1'b1) begin
        diff3 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff3 <= section_cast8;
        end
      end
    end // comb_delay_section8

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section8
      if (reset == 1'b1) begin
        cic_pipeline8 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline8 <= section_out8;
        end
      end
    end // cic_pipeline_process_section8

  //   ------------------ Section # 9 : Comb ------------------

  assign section_in9 = cic_pipeline8;

  assign section_cast9 = section_in9[27:1];

  assign sub_cast_6 = section_cast9;
  assign sub_cast_7 = diff4;
  assign sub_temp_3 = sub_cast_6 - sub_cast_7;
  assign section_out9 = sub_temp_3[26:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section9
      if (reset == 1'b1) begin
        diff4 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff4 <= section_cast9;
        end
      end
    end // comb_delay_section9

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section9
      if (reset == 1'b1) begin
        cic_pipeline9 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline9 <= section_out9;
        end
      end
    end // cic_pipeline_process_section9

  //   ------------------ Section # 10 : Comb ------------------

  assign section_in10 = cic_pipeline9;

  assign sub_cast_8 = section_in10;
  assign sub_cast_9 = diff5;
  assign sub_temp_4 = sub_cast_8 - sub_cast_9;
  assign section_out10 = sub_temp_4[26:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section10
      if (reset == 1'b1) begin
        diff5 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff5 <= section_in10;
        end
      end
    end // comb_delay_section10

  assign output_typeconvert = section_out10[26:3];

  //   ------------------ Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: output_reg_process
      if (reset == 1'b1) begin
        output_register <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          output_register <= output_typeconvert;
        end
      end
    end // output_reg_process

  // Assignment Statements
  assign ce_out = ce_out_reg;
  assign filter_out = output_register;
endmodule  // cic_8_1_5_nofraction
