// -------------------------------------------------------------
//
// Module: cic_4_1_8_nofraction
//
// Generated by MATLAB(R) 7.2 and the Filter Design HDL Coder 1.4.
//
// Generated on: 2007-05-24 16:14:35
//
// -------------------------------------------------------------

// -------------------------------------------------------------
// HDL Code Generation Options:
//
// TargetLanguage: Verilog
// Name: cic_4_1_8_nofraction
// TargetDirectory: c:\HPSDR\trunk\VK6APH\Mercury\Matlab-files
// FIRAdderStyle: tree
// CoeffMultipliers: csd
// SerialPartition: -1
// AddPipelineRegisters: On
// CastBeforeSum: On
//
// Filter Settings:
//
// Discrete-Time FIR Multirate Filter (real)
// -----------------------------------------
// Filter Structure        : Cascaded Integrator-Comb Decimator
// Decimation Factor       : 4
// Differential Delay      : 1
// Number of Sections      : 8
// Stable                  : Yes
// Linear Phase            : Yes (Type 1)
//
// Input                   : s24,0
// Output                  : s24,-16
// Filter Internals        : Minimum Word Lengths
//   Integrator Section 1  : s40,0
//   Integrator Section 2  : s39,-1
//   Integrator Section 3  : s37,-3
//   Integrator Section 4  : s36,-4
//   Integrator Section 5  : s35,-5
//   Integrator Section 6  : s34,-6
//   Integrator Section 7  : s34,-6
//   Integrator Section 8  : s33,-7
//   Comb Section 1        : s33,-7
//   Comb Section 2        : s32,-8
//   Comb Section 3        : s31,-9
//   Comb Section 4        : s30,-10
//   Comb Section 5        : s30,-10
//   Comb Section 6        : s29,-11
//   Comb Section 7        : s28,-12
//   Comb Section 8        : s27,-13
//
// Implementation Cost
// Number of Multipliers : 0
// Number of Adders      : 16
// Number of States      : 16
// MultPerInputSample    : 0
// AddPerInputSample     : 10
// -------------------------------------------------------------

`timescale 1 ns / 1 ns

module cic_4_1_8_nofraction 
               (
                clk,
                clk_enable,
                reset,
                filter_in,
                filter_out,
                ce_out
                );

  input   clk; 
  input   clk_enable; 
  input   reset; 
  input   signed [23:0] filter_in; //sfix24
  output  signed [23:0] filter_out; //sfix24_E16
  output  ce_out; 

////////////////////////////////////////////////////////////////
//Module Architecture: cic_4_1_8_nofraction
////////////////////////////////////////////////////////////////
  // Local Functions
  // Type Definitions
  // Constants
  // Signals
  reg  [1:0] cur_count; // ufix2
  wire phase_1; // boolean
  wire ce_delayline; // boolean
  reg  int_delay_pipe [0:6] ; // boolean
  wire ce_gated; // boolean
  reg  ce_out_reg; // boolean
  //   
  reg  signed [23:0] input_register; // sfix24
  //   -- Section 1 Signals 
  wire signed [23:0] section_in1; // sfix24
  wire signed [39:0] section_cast1; // sfix40
  wire signed [39:0] sum1; // sfix40
  reg  signed [39:0] section_out1; // sfix40
  wire signed [39:0] add_cast; // sfix40
  wire signed [39:0] add_cast_1; // sfix40
  wire signed [40:0] add_temp; // sfix41
  //   -- Section 2 Signals 
  wire signed [39:0] section_in2; // sfix40
  wire signed [38:0] section_cast2; // sfix39_E1
  wire signed [38:0] sum2; // sfix39_E1
  reg  signed [38:0] section_out2; // sfix39_E1
  wire signed [38:0] add_cast_2; // sfix39_E1
  wire signed [38:0] add_cast_3; // sfix39_E1
  wire signed [39:0] add_temp_1; // sfix40_E1
  //   -- Section 3 Signals 
  wire signed [38:0] section_in3; // sfix39_E1
  wire signed [36:0] section_cast3; // sfix37_E3
  wire signed [36:0] sum3; // sfix37_E3
  reg  signed [36:0] section_out3; // sfix37_E3
  wire signed [36:0] add_cast_4; // sfix37_E3
  wire signed [36:0] add_cast_5; // sfix37_E3
  wire signed [37:0] add_temp_2; // sfix38_E3
  //   -- Section 4 Signals 
  wire signed [36:0] section_in4; // sfix37_E3
  wire signed [35:0] section_cast4; // sfix36_E4
  wire signed [35:0] sum4; // sfix36_E4
  reg  signed [35:0] section_out4; // sfix36_E4
  wire signed [35:0] add_cast_6; // sfix36_E4
  wire signed [35:0] add_cast_7; // sfix36_E4
  wire signed [36:0] add_temp_3; // sfix37_E4
  //   -- Section 5 Signals 
  wire signed [35:0] section_in5; // sfix36_E4
  wire signed [34:0] section_cast5; // sfix35_E5
  wire signed [34:0] sum5; // sfix35_E5
  reg  signed [34:0] section_out5; // sfix35_E5
  wire signed [34:0] add_cast_8; // sfix35_E5
  wire signed [34:0] add_cast_9; // sfix35_E5
  wire signed [35:0] add_temp_4; // sfix36_E5
  //   -- Section 6 Signals 
  wire signed [34:0] section_in6; // sfix35_E5
  wire signed [33:0] section_cast6; // sfix34_E6
  wire signed [33:0] sum6; // sfix34_E6
  reg  signed [33:0] section_out6; // sfix34_E6
  wire signed [33:0] add_cast_10; // sfix34_E6
  wire signed [33:0] add_cast_11; // sfix34_E6
  wire signed [34:0] add_temp_5; // sfix35_E6
  //   -- Section 7 Signals 
  wire signed [33:0] section_in7; // sfix34_E6
  wire signed [33:0] sum7; // sfix34_E6
  reg  signed [33:0] section_out7; // sfix34_E6
  wire signed [33:0] add_cast_12; // sfix34_E6
  wire signed [33:0] add_cast_13; // sfix34_E6
  wire signed [34:0] add_temp_6; // sfix35_E6
  //   -- Section 8 Signals 
  wire signed [33:0] section_in8; // sfix34_E6
  wire signed [32:0] section_cast8; // sfix33_E7
  wire signed [32:0] sum8; // sfix33_E7
  reg  signed [32:0] section_out8; // sfix33_E7
  wire signed [32:0] add_cast_14; // sfix33_E7
  wire signed [32:0] add_cast_15; // sfix33_E7
  wire signed [33:0] add_temp_7; // sfix34_E7
  //   -- Section 9 Signals 
  wire signed [32:0] section_in9; // sfix33_E7
  reg  signed [32:0] diff1; // sfix33_E7
  wire signed [32:0] section_out9; // sfix33_E7
  wire signed [32:0] sub_cast; // sfix33_E7
  wire signed [32:0] sub_cast_1; // sfix33_E7
  wire signed [33:0] sub_temp; // sfix34_E7
  reg  signed [32:0] cic_pipeline9; // sfix33_E7
  //   -- Section 10 Signals 
  wire signed [32:0] section_in10; // sfix33_E7
  wire signed [31:0] section_cast10; // sfix32_E8
  reg  signed [31:0] diff2; // sfix32_E8
  wire signed [31:0] section_out10; // sfix32_E8
  wire signed [31:0] sub_cast_2; // sfix32_E8
  wire signed [31:0] sub_cast_3; // sfix32_E8
  wire signed [32:0] sub_temp_1; // sfix33_E8
  reg  signed [31:0] cic_pipeline10; // sfix32_E8
  //   -- Section 11 Signals 
  wire signed [31:0] section_in11; // sfix32_E8
  wire signed [30:0] section_cast11; // sfix31_E9
  reg  signed [30:0] diff3; // sfix31_E9
  wire signed [30:0] section_out11; // sfix31_E9
  wire signed [30:0] sub_cast_4; // sfix31_E9
  wire signed [30:0] sub_cast_5; // sfix31_E9
  wire signed [31:0] sub_temp_2; // sfix32_E9
  reg  signed [30:0] cic_pipeline11; // sfix31_E9
  //   -- Section 12 Signals 
  wire signed [30:0] section_in12; // sfix31_E9
  wire signed [29:0] section_cast12; // sfix30_E10
  reg  signed [29:0] diff4; // sfix30_E10
  wire signed [29:0] section_out12; // sfix30_E10
  wire signed [29:0] sub_cast_6; // sfix30_E10
  wire signed [29:0] sub_cast_7; // sfix30_E10
  wire signed [30:0] sub_temp_3; // sfix31_E10
  reg  signed [29:0] cic_pipeline12; // sfix30_E10
  //   -- Section 13 Signals 
  wire signed [29:0] section_in13; // sfix30_E10
  reg  signed [29:0] diff5; // sfix30_E10
  wire signed [29:0] section_out13; // sfix30_E10
  wire signed [29:0] sub_cast_8; // sfix30_E10
  wire signed [29:0] sub_cast_9; // sfix30_E10
  wire signed [30:0] sub_temp_4; // sfix31_E10
  reg  signed [29:0] cic_pipeline13; // sfix30_E10
  //   -- Section 14 Signals 
  wire signed [29:0] section_in14; // sfix30_E10
  wire signed [28:0] section_cast14; // sfix29_E11
  reg  signed [28:0] diff6; // sfix29_E11
  wire signed [28:0] section_out14; // sfix29_E11
  wire signed [28:0] sub_cast_10; // sfix29_E11
  wire signed [28:0] sub_cast_11; // sfix29_E11
  wire signed [29:0] sub_temp_5; // sfix30_E11
  reg  signed [28:0] cic_pipeline14; // sfix29_E11
  //   -- Section 15 Signals 
  wire signed [28:0] section_in15; // sfix29_E11
  wire signed [27:0] section_cast15; // sfix28_E12
  reg  signed [27:0] diff7; // sfix28_E12
  wire signed [27:0] section_out15; // sfix28_E12
  wire signed [27:0] sub_cast_12; // sfix28_E12
  wire signed [27:0] sub_cast_13; // sfix28_E12
  wire signed [28:0] sub_temp_6; // sfix29_E12
  reg  signed [27:0] cic_pipeline15; // sfix28_E12
  //   -- Section 16 Signals 
  wire signed [27:0] section_in16; // sfix28_E12
  wire signed [26:0] section_cast16; // sfix27_E13
  reg  signed [26:0] diff8; // sfix27_E13
  wire signed [26:0] section_out16; // sfix27_E13
  wire signed [26:0] sub_cast_14; // sfix27_E13
  wire signed [26:0] sub_cast_15; // sfix27_E13
  wire signed [27:0] sub_temp_7; // sfix28_E13
  wire signed [23:0] output_typeconvert; // sfix24_E16
  //   
  reg  signed [23:0] output_register; // sfix24_E16

  // Block Statements
  //   ------------------ CE Output Generation ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output
      if (reset == 1'b1) begin
        cur_count <= 2'b00;
      end
      else begin
        if (clk_enable == 1'b1) begin
          if (cur_count == 2'b11) begin
            cur_count <= 2'b00;
          end
          else begin
            cur_count <= cur_count + 1;
          end
        end
      end
    end // ce_output

  assign  phase_1 = (cur_count == 2'b01 && clk_enable == 1'b1)? 1 : 0;

  always @( posedge clk or posedge reset)
    begin: ce_delay
      if (reset == 1'b1) begin
        int_delay_pipe[0] <= 1'b0;
        int_delay_pipe[1] <= 1'b0;
        int_delay_pipe[2] <= 1'b0;
        int_delay_pipe[3] <= 1'b0;
        int_delay_pipe[4] <= 1'b0;
        int_delay_pipe[5] <= 1'b0;
        int_delay_pipe[6] <= 1'b0;
      end
      else begin
        if (phase_1 == 1'b1) begin
        int_delay_pipe[0] <= clk_enable;
        int_delay_pipe[1] <= int_delay_pipe[0];
        int_delay_pipe[2] <= int_delay_pipe[1];
        int_delay_pipe[3] <= int_delay_pipe[2];
        int_delay_pipe[4] <= int_delay_pipe[3];
        int_delay_pipe[5] <= int_delay_pipe[4];
        int_delay_pipe[6] <= int_delay_pipe[5];
        end
      end
    end // ce_delay

    assign ce_delayline = int_delay_pipe[6];
  assign ce_gated =  ce_delayline & phase_1;

  //   ------------------ CE Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output_register
      if (reset == 1'b1) begin
        ce_out_reg <= 1'b0;
      end
      else begin
          ce_out_reg <= ce_gated;
      end
    end // ce_output_register

  //   ------------------ Input Register ------------------

  always @ (posedge clk or posedge reset)
    begin: input_reg_process
      if (reset == 1'b1) begin
        input_register <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          input_register <= filter_in;
        end
      end
    end // input_reg_process

  //   ------------------ Section # 1 : Integrator ------------------

  assign section_in1 = input_register;

  assign section_cast1 = $signed({{16{section_in1[23]}}, section_in1});

  assign add_cast = section_cast1;
  assign add_cast_1 = section_out1;
  assign add_temp = add_cast + add_cast_1;
  assign sum1 = add_temp[39:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section1
      if (reset == 1'b1) begin
        section_out1 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out1 <= sum1;
        end
      end
    end // integrator_delay_section1

  //   ------------------ Section # 2 : Integrator ------------------

  assign section_in2 = section_out1;

  assign section_cast2 = section_in2[39:1];

  assign add_cast_2 = section_cast2;
  assign add_cast_3 = section_out2;
  assign add_temp_1 = add_cast_2 + add_cast_3;
  assign sum2 = add_temp_1[38:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section2
      if (reset == 1'b1) begin
        section_out2 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out2 <= sum2;
        end
      end
    end // integrator_delay_section2

  //   ------------------ Section # 3 : Integrator ------------------

  assign section_in3 = section_out2;

  assign section_cast3 = section_in3[38:2];

  assign add_cast_4 = section_cast3;
  assign add_cast_5 = section_out3;
  assign add_temp_2 = add_cast_4 + add_cast_5;
  assign sum3 = add_temp_2[36:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section3
      if (reset == 1'b1) begin
        section_out3 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out3 <= sum3;
        end
      end
    end // integrator_delay_section3

  //   ------------------ Section # 4 : Integrator ------------------

  assign section_in4 = section_out3;

  assign section_cast4 = section_in4[36:1];

  assign add_cast_6 = section_cast4;
  assign add_cast_7 = section_out4;
  assign add_temp_3 = add_cast_6 + add_cast_7;
  assign sum4 = add_temp_3[35:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section4
      if (reset == 1'b1) begin
        section_out4 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out4 <= sum4;
        end
      end
    end // integrator_delay_section4

  //   ------------------ Section # 5 : Integrator ------------------

  assign section_in5 = section_out4;

  assign section_cast5 = section_in5[35:1];

  assign add_cast_8 = section_cast5;
  assign add_cast_9 = section_out5;
  assign add_temp_4 = add_cast_8 + add_cast_9;
  assign sum5 = add_temp_4[34:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section5
      if (reset == 1'b1) begin
        section_out5 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out5 <= sum5;
        end
      end
    end // integrator_delay_section5

  //   ------------------ Section # 6 : Integrator ------------------

  assign section_in6 = section_out5;

  assign section_cast6 = section_in6[34:1];

  assign add_cast_10 = section_cast6;
  assign add_cast_11 = section_out6;
  assign add_temp_5 = add_cast_10 + add_cast_11;
  assign sum6 = add_temp_5[33:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section6
      if (reset == 1'b1) begin
        section_out6 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out6 <= sum6;
        end
      end
    end // integrator_delay_section6

  //   ------------------ Section # 7 : Integrator ------------------

  assign section_in7 = section_out6;

  assign add_cast_12 = section_in7;
  assign add_cast_13 = section_out7;
  assign add_temp_6 = add_cast_12 + add_cast_13;
  assign sum7 = add_temp_6[33:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section7
      if (reset == 1'b1) begin
        section_out7 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out7 <= sum7;
        end
      end
    end // integrator_delay_section7

  //   ------------------ Section # 8 : Integrator ------------------

  assign section_in8 = section_out7;

  assign section_cast8 = section_in8[33:1];

  assign add_cast_14 = section_cast8;
  assign add_cast_15 = section_out8;
  assign add_temp_7 = add_cast_14 + add_cast_15;
  assign sum8 = add_temp_7[32:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section8
      if (reset == 1'b1) begin
        section_out8 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out8 <= sum8;
        end
      end
    end // integrator_delay_section8

  //   ------------------ Section # 9 : Comb ------------------

  assign section_in9 = section_out8;

  assign sub_cast = section_in9;
  assign sub_cast_1 = diff1;
  assign sub_temp = sub_cast - sub_cast_1;
  assign section_out9 = sub_temp[32:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section9
      if (reset == 1'b1) begin
        diff1 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff1 <= section_in9;
        end
      end
    end // comb_delay_section9

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section9
      if (reset == 1'b1) begin
        cic_pipeline9 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline9 <= section_out9;
        end
      end
    end // cic_pipeline_process_section9

  //   ------------------ Section # 10 : Comb ------------------

  assign section_in10 = cic_pipeline9;

  assign section_cast10 = section_in10[32:1];

  assign sub_cast_2 = section_cast10;
  assign sub_cast_3 = diff2;
  assign sub_temp_1 = sub_cast_2 - sub_cast_3;
  assign section_out10 = sub_temp_1[31:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section10
      if (reset == 1'b1) begin
        diff2 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff2 <= section_cast10;
        end
      end
    end // comb_delay_section10

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section10
      if (reset == 1'b1) begin
        cic_pipeline10 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline10 <= section_out10;
        end
      end
    end // cic_pipeline_process_section10

  //   ------------------ Section # 11 : Comb ------------------

  assign section_in11 = cic_pipeline10;

  assign section_cast11 = section_in11[31:1];

  assign sub_cast_4 = section_cast11;
  assign sub_cast_5 = diff3;
  assign sub_temp_2 = sub_cast_4 - sub_cast_5;
  assign section_out11 = sub_temp_2[30:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section11
      if (reset == 1'b1) begin
        diff3 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff3 <= section_cast11;
        end
      end
    end // comb_delay_section11

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section11
      if (reset == 1'b1) begin
        cic_pipeline11 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline11 <= section_out11;
        end
      end
    end // cic_pipeline_process_section11

  //   ------------------ Section # 12 : Comb ------------------

  assign section_in12 = cic_pipeline11;

  assign section_cast12 = section_in12[30:1];

  assign sub_cast_6 = section_cast12;
  assign sub_cast_7 = diff4;
  assign sub_temp_3 = sub_cast_6 - sub_cast_7;
  assign section_out12 = sub_temp_3[29:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section12
      if (reset == 1'b1) begin
        diff4 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff4 <= section_cast12;
        end
      end
    end // comb_delay_section12

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section12
      if (reset == 1'b1) begin
        cic_pipeline12 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline12 <= section_out12;
        end
      end
    end // cic_pipeline_process_section12

  //   ------------------ Section # 13 : Comb ------------------

  assign section_in13 = cic_pipeline12;

  assign sub_cast_8 = section_in13;
  assign sub_cast_9 = diff5;
  assign sub_temp_4 = sub_cast_8 - sub_cast_9;
  assign section_out13 = sub_temp_4[29:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section13
      if (reset == 1'b1) begin
        diff5 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff5 <= section_in13;
        end
      end
    end // comb_delay_section13

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section13
      if (reset == 1'b1) begin
        cic_pipeline13 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline13 <= section_out13;
        end
      end
    end // cic_pipeline_process_section13

  //   ------------------ Section # 14 : Comb ------------------

  assign section_in14 = cic_pipeline13;

  assign section_cast14 = section_in14[29:1];

  assign sub_cast_10 = section_cast14;
  assign sub_cast_11 = diff6;
  assign sub_temp_5 = sub_cast_10 - sub_cast_11;
  assign section_out14 = sub_temp_5[28:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section14
      if (reset == 1'b1) begin
        diff6 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff6 <= section_cast14;
        end
      end
    end // comb_delay_section14

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section14
      if (reset == 1'b1) begin
        cic_pipeline14 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline14 <= section_out14;
        end
      end
    end // cic_pipeline_process_section14

  //   ------------------ Section # 15 : Comb ------------------

  assign section_in15 = cic_pipeline14;

  assign section_cast15 = section_in15[28:1];

  assign sub_cast_12 = section_cast15;
  assign sub_cast_13 = diff7;
  assign sub_temp_6 = sub_cast_12 - sub_cast_13;
  assign section_out15 = sub_temp_6[27:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section15
      if (reset == 1'b1) begin
        diff7 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff7 <= section_cast15;
        end
      end
    end // comb_delay_section15

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section15
      if (reset == 1'b1) begin
        cic_pipeline15 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline15 <= section_out15;
        end
      end
    end // cic_pipeline_process_section15

  //   ------------------ Section # 16 : Comb ------------------

  assign section_in16 = cic_pipeline15;

  assign section_cast16 = section_in16[27:1];

  assign sub_cast_14 = section_cast16;
  assign sub_cast_15 = diff8;
  assign sub_temp_7 = sub_cast_14 - sub_cast_15;
  assign section_out16 = sub_temp_7[26:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section16
      if (reset == 1'b1) begin
        diff8 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff8 <= section_cast16;
        end
      end
    end // comb_delay_section16

  assign output_typeconvert = section_out16[26:3];

  //   ------------------ Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: output_reg_process
      if (reset == 1'b1) begin
        output_register <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          output_register <= output_typeconvert;
        end
      end
    end // output_reg_process

  // Assignment Statements
  assign ce_out = ce_out_reg;
  assign filter_out = output_register;
endmodule  // cic_4_1_8_nofraction
