// -------------------------------------------------------------
//
// Module: cic_4_1_12_nofraction
//
// Generated by MATLAB(R) 7.2 and the Filter Design HDL Coder 1.4.
//
// Generated on: 2008-12-10 14:39:58
//
// -------------------------------------------------------------

// -------------------------------------------------------------
// HDL Code Generation Options:
//
// TargetLanguage: Verilog
// Name: cic_4_1_12_nofraction
// TargetDirectory: c:\HPSDR\trunk\VK6APH\Mercury\Matlab-files
// FIRAdderStyle: tree
// CoeffMultipliers: csd
// SerialPartition: -1
// AddPipelineRegisters: On
// CastBeforeSum: On
//
// Filter Settings:
//
// Discrete-Time FIR Multirate Filter (real)
// -----------------------------------------
// Filter Structure         : Cascaded Integrator-Comb Decimator
// Decimation Factor        : 4
// Differential Delay       : 1
// Number of Sections       : 12
// Stable                   : Yes
// Linear Phase             : Yes (Type 1)
//
// Input                    : s24,0
// Output                   : s24,-24
// Filter Internals         : Minimum Word Lengths
//   Integrator Section 1   : s48,0
//   Integrator Section 2   : s48,0
//   Integrator Section 3   : s45,-3
//   Integrator Section 4   : s43,-5
//   Integrator Section 5   : s42,-6
//   Integrator Section 6   : s41,-7
//   Integrator Section 7   : s40,-8
//   Integrator Section 8   : s40,-8
//   Integrator Section 9   : s39,-9
//   Integrator Section 10  : s38,-10
//   Integrator Section 11  : s38,-10
//   Integrator Section 12  : s38,-10
//   Comb Section 1         : s37,-11
//   Comb Section 2         : s37,-11
//   Comb Section 3         : s36,-12
//   Comb Section 4         : s35,-13
//   Comb Section 5         : s34,-14
//   Comb Section 6         : s33,-15
//   Comb Section 7         : s32,-16
//   Comb Section 8         : s31,-17
//   Comb Section 9         : s30,-18
//   Comb Section 10        : s29,-19
//   Comb Section 11        : s28,-20
//   Comb Section 12        : s27,-21
//
// Implementation Cost
// Number of Multipliers : 0
// Number of Adders      : 24
// Number of States      : 24
// MultPerInputSample    : 0
// AddPerInputSample     : 15
// -------------------------------------------------------------

`timescale 1 ns / 1 ns

module cic_4_1_12_nofraction 
               (
                clk,
                clk_enable,
                reset,
                filter_in,
                filter_out,
                ce_out
                );

  input   clk; 
  input   clk_enable; 
  input   reset; 
  input   signed [23:0] filter_in; //sfix24
  output  signed [23:0] filter_out; //sfix24_E24
  output  ce_out; 

////////////////////////////////////////////////////////////////
//Module Architecture: cic_4_1_12_nofraction
////////////////////////////////////////////////////////////////
  // Local Functions
  // Type Definitions
  // Constants
  // Signals
  reg  [1:0] cur_count; // ufix2
  wire phase_1; // boolean
  wire ce_delayline; // boolean
  reg  int_delay_pipe [0:10] ; // boolean
  wire ce_gated; // boolean
  reg  ce_out_reg; // boolean
  //   
  reg  signed [23:0] input_register; // sfix24
  //   -- Section 1 Signals 
  wire signed [23:0] section_in1; // sfix24
  wire signed [47:0] section_cast1; // sfix48
  wire signed [47:0] sum1; // sfix48
  reg  signed [47:0] section_out1; // sfix48
  wire signed [47:0] add_cast; // sfix48
  wire signed [47:0] add_cast_1; // sfix48
  wire signed [48:0] add_temp; // sfix49
  //   -- Section 2 Signals 
  wire signed [47:0] section_in2; // sfix48
  wire signed [47:0] sum2; // sfix48
  reg  signed [47:0] section_out2; // sfix48
  wire signed [47:0] add_cast_2; // sfix48
  wire signed [47:0] add_cast_3; // sfix48
  wire signed [48:0] add_temp_1; // sfix49
  //   -- Section 3 Signals 
  wire signed [47:0] section_in3; // sfix48
  wire signed [44:0] section_cast3; // sfix45_E3
  wire signed [44:0] sum3; // sfix45_E3
  reg  signed [44:0] section_out3; // sfix45_E3
  wire signed [44:0] add_cast_4; // sfix45_E3
  wire signed [44:0] add_cast_5; // sfix45_E3
  wire signed [45:0] add_temp_2; // sfix46_E3
  //   -- Section 4 Signals 
  wire signed [44:0] section_in4; // sfix45_E3
  wire signed [42:0] section_cast4; // sfix43_E5
  wire signed [42:0] sum4; // sfix43_E5
  reg  signed [42:0] section_out4; // sfix43_E5
  wire signed [42:0] add_cast_6; // sfix43_E5
  wire signed [42:0] add_cast_7; // sfix43_E5
  wire signed [43:0] add_temp_3; // sfix44_E5
  //   -- Section 5 Signals 
  wire signed [42:0] section_in5; // sfix43_E5
  wire signed [41:0] section_cast5; // sfix42_E6
  wire signed [41:0] sum5; // sfix42_E6
  reg  signed [41:0] section_out5; // sfix42_E6
  wire signed [41:0] add_cast_8; // sfix42_E6
  wire signed [41:0] add_cast_9; // sfix42_E6
  wire signed [42:0] add_temp_4; // sfix43_E6
  //   -- Section 6 Signals 
  wire signed [41:0] section_in6; // sfix42_E6
  wire signed [40:0] section_cast6; // sfix41_E7
  wire signed [40:0] sum6; // sfix41_E7
  reg  signed [40:0] section_out6; // sfix41_E7
  wire signed [40:0] add_cast_10; // sfix41_E7
  wire signed [40:0] add_cast_11; // sfix41_E7
  wire signed [41:0] add_temp_5; // sfix42_E7
  //   -- Section 7 Signals 
  wire signed [40:0] section_in7; // sfix41_E7
  wire signed [39:0] section_cast7; // sfix40_E8
  wire signed [39:0] sum7; // sfix40_E8
  reg  signed [39:0] section_out7; // sfix40_E8
  wire signed [39:0] add_cast_12; // sfix40_E8
  wire signed [39:0] add_cast_13; // sfix40_E8
  wire signed [40:0] add_temp_6; // sfix41_E8
  //   -- Section 8 Signals 
  wire signed [39:0] section_in8; // sfix40_E8
  wire signed [39:0] sum8; // sfix40_E8
  reg  signed [39:0] section_out8; // sfix40_E8
  wire signed [39:0] add_cast_14; // sfix40_E8
  wire signed [39:0] add_cast_15; // sfix40_E8
  wire signed [40:0] add_temp_7; // sfix41_E8
  //   -- Section 9 Signals 
  wire signed [39:0] section_in9; // sfix40_E8
  wire signed [38:0] section_cast9; // sfix39_E9
  wire signed [38:0] sum9; // sfix39_E9
  reg  signed [38:0] section_out9; // sfix39_E9
  wire signed [38:0] add_cast_16; // sfix39_E9
  wire signed [38:0] add_cast_17; // sfix39_E9
  wire signed [39:0] add_temp_8; // sfix40_E9
  //   -- Section 10 Signals 
  wire signed [38:0] section_in10; // sfix39_E9
  wire signed [37:0] section_cast10; // sfix38_E10
  wire signed [37:0] sum10; // sfix38_E10
  reg  signed [37:0] section_out10; // sfix38_E10
  wire signed [37:0] add_cast_18; // sfix38_E10
  wire signed [37:0] add_cast_19; // sfix38_E10
  wire signed [38:0] add_temp_9; // sfix39_E10
  //   -- Section 11 Signals 
  wire signed [37:0] section_in11; // sfix38_E10
  wire signed [37:0] sum11; // sfix38_E10
  reg  signed [37:0] section_out11; // sfix38_E10
  wire signed [37:0] add_cast_20; // sfix38_E10
  wire signed [37:0] add_cast_21; // sfix38_E10
  wire signed [38:0] add_temp_10; // sfix39_E10
  //   -- Section 12 Signals 
  wire signed [37:0] section_in12; // sfix38_E10
  wire signed [37:0] sum12; // sfix38_E10
  reg  signed [37:0] section_out12; // sfix38_E10
  wire signed [37:0] add_cast_22; // sfix38_E10
  wire signed [37:0] add_cast_23; // sfix38_E10
  wire signed [38:0] add_temp_11; // sfix39_E10
  //   -- Section 13 Signals 
  wire signed [37:0] section_in13; // sfix38_E10
  wire signed [36:0] section_cast13; // sfix37_E11
  reg  signed [36:0] diff1; // sfix37_E11
  wire signed [36:0] section_out13; // sfix37_E11
  wire signed [36:0] sub_cast; // sfix37_E11
  wire signed [36:0] sub_cast_1; // sfix37_E11
  wire signed [37:0] sub_temp; // sfix38_E11
  reg  signed [36:0] cic_pipeline13; // sfix37_E11
  //   -- Section 14 Signals 
  wire signed [36:0] section_in14; // sfix37_E11
  reg  signed [36:0] diff2; // sfix37_E11
  wire signed [36:0] section_out14; // sfix37_E11
  wire signed [36:0] sub_cast_2; // sfix37_E11
  wire signed [36:0] sub_cast_3; // sfix37_E11
  wire signed [37:0] sub_temp_1; // sfix38_E11
  reg  signed [36:0] cic_pipeline14; // sfix37_E11
  //   -- Section 15 Signals 
  wire signed [36:0] section_in15; // sfix37_E11
  wire signed [35:0] section_cast15; // sfix36_E12
  reg  signed [35:0] diff3; // sfix36_E12
  wire signed [35:0] section_out15; // sfix36_E12
  wire signed [35:0] sub_cast_4; // sfix36_E12
  wire signed [35:0] sub_cast_5; // sfix36_E12
  wire signed [36:0] sub_temp_2; // sfix37_E12
  reg  signed [35:0] cic_pipeline15; // sfix36_E12
  //   -- Section 16 Signals 
  wire signed [35:0] section_in16; // sfix36_E12
  wire signed [34:0] section_cast16; // sfix35_E13
  reg  signed [34:0] diff4; // sfix35_E13
  wire signed [34:0] section_out16; // sfix35_E13
  wire signed [34:0] sub_cast_6; // sfix35_E13
  wire signed [34:0] sub_cast_7; // sfix35_E13
  wire signed [35:0] sub_temp_3; // sfix36_E13
  reg  signed [34:0] cic_pipeline16; // sfix35_E13
  //   -- Section 17 Signals 
  wire signed [34:0] section_in17; // sfix35_E13
  wire signed [33:0] section_cast17; // sfix34_E14
  reg  signed [33:0] diff5; // sfix34_E14
  wire signed [33:0] section_out17; // sfix34_E14
  wire signed [33:0] sub_cast_8; // sfix34_E14
  wire signed [33:0] sub_cast_9; // sfix34_E14
  wire signed [34:0] sub_temp_4; // sfix35_E14
  reg  signed [33:0] cic_pipeline17; // sfix34_E14
  //   -- Section 18 Signals 
  wire signed [33:0] section_in18; // sfix34_E14
  wire signed [32:0] section_cast18; // sfix33_E15
  reg  signed [32:0] diff6; // sfix33_E15
  wire signed [32:0] section_out18; // sfix33_E15
  wire signed [32:0] sub_cast_10; // sfix33_E15
  wire signed [32:0] sub_cast_11; // sfix33_E15
  wire signed [33:0] sub_temp_5; // sfix34_E15
  reg  signed [32:0] cic_pipeline18; // sfix33_E15
  //   -- Section 19 Signals 
  wire signed [32:0] section_in19; // sfix33_E15
  wire signed [31:0] section_cast19; // sfix32_E16
  reg  signed [31:0] diff7; // sfix32_E16
  wire signed [31:0] section_out19; // sfix32_E16
  wire signed [31:0] sub_cast_12; // sfix32_E16
  wire signed [31:0] sub_cast_13; // sfix32_E16
  wire signed [32:0] sub_temp_6; // sfix33_E16
  reg  signed [31:0] cic_pipeline19; // sfix32_E16
  //   -- Section 20 Signals 
  wire signed [31:0] section_in20; // sfix32_E16
  wire signed [30:0] section_cast20; // sfix31_E17
  reg  signed [30:0] diff8; // sfix31_E17
  wire signed [30:0] section_out20; // sfix31_E17
  wire signed [30:0] sub_cast_14; // sfix31_E17
  wire signed [30:0] sub_cast_15; // sfix31_E17
  wire signed [31:0] sub_temp_7; // sfix32_E17
  reg  signed [30:0] cic_pipeline20; // sfix31_E17
  //   -- Section 21 Signals 
  wire signed [30:0] section_in21; // sfix31_E17
  wire signed [29:0] section_cast21; // sfix30_E18
  reg  signed [29:0] diff9; // sfix30_E18
  wire signed [29:0] section_out21; // sfix30_E18
  wire signed [29:0] sub_cast_16; // sfix30_E18
  wire signed [29:0] sub_cast_17; // sfix30_E18
  wire signed [30:0] sub_temp_8; // sfix31_E18
  reg  signed [29:0] cic_pipeline21; // sfix30_E18
  //   -- Section 22 Signals 
  wire signed [29:0] section_in22; // sfix30_E18
  wire signed [28:0] section_cast22; // sfix29_E19
  reg  signed [28:0] diff10; // sfix29_E19
  wire signed [28:0] section_out22; // sfix29_E19
  wire signed [28:0] sub_cast_18; // sfix29_E19
  wire signed [28:0] sub_cast_19; // sfix29_E19
  wire signed [29:0] sub_temp_9; // sfix30_E19
  reg  signed [28:0] cic_pipeline22; // sfix29_E19
  //   -- Section 23 Signals 
  wire signed [28:0] section_in23; // sfix29_E19
  wire signed [27:0] section_cast23; // sfix28_E20
  reg  signed [27:0] diff11; // sfix28_E20
  wire signed [27:0] section_out23; // sfix28_E20
  wire signed [27:0] sub_cast_20; // sfix28_E20
  wire signed [27:0] sub_cast_21; // sfix28_E20
  wire signed [28:0] sub_temp_10; // sfix29_E20
  reg  signed [27:0] cic_pipeline23; // sfix28_E20
  //   -- Section 24 Signals 
  wire signed [27:0] section_in24; // sfix28_E20
  wire signed [26:0] section_cast24; // sfix27_E21
  reg  signed [26:0] diff12; // sfix27_E21
  wire signed [26:0] section_out24; // sfix27_E21
  wire signed [26:0] sub_cast_22; // sfix27_E21
  wire signed [26:0] sub_cast_23; // sfix27_E21
  wire signed [27:0] sub_temp_11; // sfix28_E21
  wire signed [23:0] output_typeconvert; // sfix24_E24
  //   
  reg  signed [23:0] output_register; // sfix24_E24

  // Block Statements
  //   ------------------ CE Output Generation ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output
      if (reset == 1'b1) begin
        cur_count <= 2'b00;
      end
      else begin
        if (clk_enable == 1'b1) begin
          if (cur_count == 2'b11) begin
            cur_count <= 2'b00;
          end
          else begin
            cur_count <= cur_count + 1;
          end
        end
      end
    end // ce_output

  assign  phase_1 = (cur_count == 2'b01 && clk_enable == 1'b1)? 1 : 0;

  always @( posedge clk or posedge reset)
    begin: ce_delay
      if (reset == 1'b1) begin
        int_delay_pipe[0] <= 1'b0;
        int_delay_pipe[1] <= 1'b0;
        int_delay_pipe[2] <= 1'b0;
        int_delay_pipe[3] <= 1'b0;
        int_delay_pipe[4] <= 1'b0;
        int_delay_pipe[5] <= 1'b0;
        int_delay_pipe[6] <= 1'b0;
        int_delay_pipe[7] <= 1'b0;
        int_delay_pipe[8] <= 1'b0;
        int_delay_pipe[9] <= 1'b0;
        int_delay_pipe[10] <= 1'b0;
      end
      else begin
        if (phase_1 == 1'b1) begin
        int_delay_pipe[0] <= clk_enable;
        int_delay_pipe[1] <= int_delay_pipe[0];
        int_delay_pipe[2] <= int_delay_pipe[1];
        int_delay_pipe[3] <= int_delay_pipe[2];
        int_delay_pipe[4] <= int_delay_pipe[3];
        int_delay_pipe[5] <= int_delay_pipe[4];
        int_delay_pipe[6] <= int_delay_pipe[5];
        int_delay_pipe[7] <= int_delay_pipe[6];
        int_delay_pipe[8] <= int_delay_pipe[7];
        int_delay_pipe[9] <= int_delay_pipe[8];
        int_delay_pipe[10] <= int_delay_pipe[9];
        end
      end
    end // ce_delay

    assign ce_delayline = int_delay_pipe[10];
  assign ce_gated =  ce_delayline & phase_1;

  //   ------------------ CE Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output_register
      if (reset == 1'b1) begin
        ce_out_reg <= 1'b0;
      end
      else begin
          ce_out_reg <= ce_gated;
      end
    end // ce_output_register

  //   ------------------ Input Register ------------------

  always @ (posedge clk or posedge reset)
    begin: input_reg_process
      if (reset == 1'b1) begin
        input_register <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          input_register <= filter_in;
        end
      end
    end // input_reg_process

  //   ------------------ Section # 1 : Integrator ------------------

  assign section_in1 = input_register;

  assign section_cast1 = $signed({{24{section_in1[23]}}, section_in1});

  assign add_cast = section_cast1;
  assign add_cast_1 = section_out1;
  assign add_temp = add_cast + add_cast_1;
  assign sum1 = add_temp[47:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section1
      if (reset == 1'b1) begin
        section_out1 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out1 <= sum1;
        end
      end
    end // integrator_delay_section1

  //   ------------------ Section # 2 : Integrator ------------------

  assign section_in2 = section_out1;

  assign add_cast_2 = section_in2;
  assign add_cast_3 = section_out2;
  assign add_temp_1 = add_cast_2 + add_cast_3;
  assign sum2 = add_temp_1[47:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section2
      if (reset == 1'b1) begin
        section_out2 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out2 <= sum2;
        end
      end
    end // integrator_delay_section2

  //   ------------------ Section # 3 : Integrator ------------------

  assign section_in3 = section_out2;

  assign section_cast3 = section_in3[47:3];

  assign add_cast_4 = section_cast3;
  assign add_cast_5 = section_out3;
  assign add_temp_2 = add_cast_4 + add_cast_5;
  assign sum3 = add_temp_2[44:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section3
      if (reset == 1'b1) begin
        section_out3 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out3 <= sum3;
        end
      end
    end // integrator_delay_section3

  //   ------------------ Section # 4 : Integrator ------------------

  assign section_in4 = section_out3;

  assign section_cast4 = section_in4[44:2];

  assign add_cast_6 = section_cast4;
  assign add_cast_7 = section_out4;
  assign add_temp_3 = add_cast_6 + add_cast_7;
  assign sum4 = add_temp_3[42:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section4
      if (reset == 1'b1) begin
        section_out4 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out4 <= sum4;
        end
      end
    end // integrator_delay_section4

  //   ------------------ Section # 5 : Integrator ------------------

  assign section_in5 = section_out4;

  assign section_cast5 = section_in5[42:1];

  assign add_cast_8 = section_cast5;
  assign add_cast_9 = section_out5;
  assign add_temp_4 = add_cast_8 + add_cast_9;
  assign sum5 = add_temp_4[41:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section5
      if (reset == 1'b1) begin
        section_out5 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out5 <= sum5;
        end
      end
    end // integrator_delay_section5

  //   ------------------ Section # 6 : Integrator ------------------

  assign section_in6 = section_out5;

  assign section_cast6 = section_in6[41:1];

  assign add_cast_10 = section_cast6;
  assign add_cast_11 = section_out6;
  assign add_temp_5 = add_cast_10 + add_cast_11;
  assign sum6 = add_temp_5[40:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section6
      if (reset == 1'b1) begin
        section_out6 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out6 <= sum6;
        end
      end
    end // integrator_delay_section6

  //   ------------------ Section # 7 : Integrator ------------------

  assign section_in7 = section_out6;

  assign section_cast7 = section_in7[40:1];

  assign add_cast_12 = section_cast7;
  assign add_cast_13 = section_out7;
  assign add_temp_6 = add_cast_12 + add_cast_13;
  assign sum7 = add_temp_6[39:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section7
      if (reset == 1'b1) begin
        section_out7 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out7 <= sum7;
        end
      end
    end // integrator_delay_section7

  //   ------------------ Section # 8 : Integrator ------------------

  assign section_in8 = section_out7;

  assign add_cast_14 = section_in8;
  assign add_cast_15 = section_out8;
  assign add_temp_7 = add_cast_14 + add_cast_15;
  assign sum8 = add_temp_7[39:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section8
      if (reset == 1'b1) begin
        section_out8 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out8 <= sum8;
        end
      end
    end // integrator_delay_section8

  //   ------------------ Section # 9 : Integrator ------------------

  assign section_in9 = section_out8;

  assign section_cast9 = section_in9[39:1];

  assign add_cast_16 = section_cast9;
  assign add_cast_17 = section_out9;
  assign add_temp_8 = add_cast_16 + add_cast_17;
  assign sum9 = add_temp_8[38:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section9
      if (reset == 1'b1) begin
        section_out9 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out9 <= sum9;
        end
      end
    end // integrator_delay_section9

  //   ------------------ Section # 10 : Integrator ------------------

  assign section_in10 = section_out9;

  assign section_cast10 = section_in10[38:1];

  assign add_cast_18 = section_cast10;
  assign add_cast_19 = section_out10;
  assign add_temp_9 = add_cast_18 + add_cast_19;
  assign sum10 = add_temp_9[37:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section10
      if (reset == 1'b1) begin
        section_out10 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out10 <= sum10;
        end
      end
    end // integrator_delay_section10

  //   ------------------ Section # 11 : Integrator ------------------

  assign section_in11 = section_out10;

  assign add_cast_20 = section_in11;
  assign add_cast_21 = section_out11;
  assign add_temp_10 = add_cast_20 + add_cast_21;
  assign sum11 = add_temp_10[37:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section11
      if (reset == 1'b1) begin
        section_out11 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out11 <= sum11;
        end
      end
    end // integrator_delay_section11

  //   ------------------ Section # 12 : Integrator ------------------

  assign section_in12 = section_out11;

  assign add_cast_22 = section_in12;
  assign add_cast_23 = section_out12;
  assign add_temp_11 = add_cast_22 + add_cast_23;
  assign sum12 = add_temp_11[37:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section12
      if (reset == 1'b1) begin
        section_out12 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out12 <= sum12;
        end
      end
    end // integrator_delay_section12

  //   ------------------ Section # 13 : Comb ------------------

  assign section_in13 = section_out12;

  assign section_cast13 = section_in13[37:1];

  assign sub_cast = section_cast13;
  assign sub_cast_1 = diff1;
  assign sub_temp = sub_cast - sub_cast_1;
  assign section_out13 = sub_temp[36:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section13
      if (reset == 1'b1) begin
        diff1 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff1 <= section_cast13;
        end
      end
    end // comb_delay_section13

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section13
      if (reset == 1'b1) begin
        cic_pipeline13 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline13 <= section_out13;
        end
      end
    end // cic_pipeline_process_section13

  //   ------------------ Section # 14 : Comb ------------------

  assign section_in14 = cic_pipeline13;

  assign sub_cast_2 = section_in14;
  assign sub_cast_3 = diff2;
  assign sub_temp_1 = sub_cast_2 - sub_cast_3;
  assign section_out14 = sub_temp_1[36:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section14
      if (reset == 1'b1) begin
        diff2 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff2 <= section_in14;
        end
      end
    end // comb_delay_section14

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section14
      if (reset == 1'b1) begin
        cic_pipeline14 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline14 <= section_out14;
        end
      end
    end // cic_pipeline_process_section14

  //   ------------------ Section # 15 : Comb ------------------

  assign section_in15 = cic_pipeline14;

  assign section_cast15 = section_in15[36:1];

  assign sub_cast_4 = section_cast15;
  assign sub_cast_5 = diff3;
  assign sub_temp_2 = sub_cast_4 - sub_cast_5;
  assign section_out15 = sub_temp_2[35:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section15
      if (reset == 1'b1) begin
        diff3 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff3 <= section_cast15;
        end
      end
    end // comb_delay_section15

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section15
      if (reset == 1'b1) begin
        cic_pipeline15 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline15 <= section_out15;
        end
      end
    end // cic_pipeline_process_section15

  //   ------------------ Section # 16 : Comb ------------------

  assign section_in16 = cic_pipeline15;

  assign section_cast16 = section_in16[35:1];

  assign sub_cast_6 = section_cast16;
  assign sub_cast_7 = diff4;
  assign sub_temp_3 = sub_cast_6 - sub_cast_7;
  assign section_out16 = sub_temp_3[34:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section16
      if (reset == 1'b1) begin
        diff4 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff4 <= section_cast16;
        end
      end
    end // comb_delay_section16

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section16
      if (reset == 1'b1) begin
        cic_pipeline16 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline16 <= section_out16;
        end
      end
    end // cic_pipeline_process_section16

  //   ------------------ Section # 17 : Comb ------------------

  assign section_in17 = cic_pipeline16;

  assign section_cast17 = section_in17[34:1];

  assign sub_cast_8 = section_cast17;
  assign sub_cast_9 = diff5;
  assign sub_temp_4 = sub_cast_8 - sub_cast_9;
  assign section_out17 = sub_temp_4[33:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section17
      if (reset == 1'b1) begin
        diff5 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff5 <= section_cast17;
        end
      end
    end // comb_delay_section17

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section17
      if (reset == 1'b1) begin
        cic_pipeline17 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline17 <= section_out17;
        end
      end
    end // cic_pipeline_process_section17

  //   ------------------ Section # 18 : Comb ------------------

  assign section_in18 = cic_pipeline17;

  assign section_cast18 = section_in18[33:1];

  assign sub_cast_10 = section_cast18;
  assign sub_cast_11 = diff6;
  assign sub_temp_5 = sub_cast_10 - sub_cast_11;
  assign section_out18 = sub_temp_5[32:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section18
      if (reset == 1'b1) begin
        diff6 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff6 <= section_cast18;
        end
      end
    end // comb_delay_section18

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section18
      if (reset == 1'b1) begin
        cic_pipeline18 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline18 <= section_out18;
        end
      end
    end // cic_pipeline_process_section18

  //   ------------------ Section # 19 : Comb ------------------

  assign section_in19 = cic_pipeline18;

  assign section_cast19 = section_in19[32:1];

  assign sub_cast_12 = section_cast19;
  assign sub_cast_13 = diff7;
  assign sub_temp_6 = sub_cast_12 - sub_cast_13;
  assign section_out19 = sub_temp_6[31:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section19
      if (reset == 1'b1) begin
        diff7 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff7 <= section_cast19;
        end
      end
    end // comb_delay_section19

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section19
      if (reset == 1'b1) begin
        cic_pipeline19 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline19 <= section_out19;
        end
      end
    end // cic_pipeline_process_section19

  //   ------------------ Section # 20 : Comb ------------------

  assign section_in20 = cic_pipeline19;

  assign section_cast20 = section_in20[31:1];

  assign sub_cast_14 = section_cast20;
  assign sub_cast_15 = diff8;
  assign sub_temp_7 = sub_cast_14 - sub_cast_15;
  assign section_out20 = sub_temp_7[30:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section20
      if (reset == 1'b1) begin
        diff8 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff8 <= section_cast20;
        end
      end
    end // comb_delay_section20

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section20
      if (reset == 1'b1) begin
        cic_pipeline20 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline20 <= section_out20;
        end
      end
    end // cic_pipeline_process_section20

  //   ------------------ Section # 21 : Comb ------------------

  assign section_in21 = cic_pipeline20;

  assign section_cast21 = section_in21[30:1];

  assign sub_cast_16 = section_cast21;
  assign sub_cast_17 = diff9;
  assign sub_temp_8 = sub_cast_16 - sub_cast_17;
  assign section_out21 = sub_temp_8[29:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section21
      if (reset == 1'b1) begin
        diff9 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff9 <= section_cast21;
        end
      end
    end // comb_delay_section21

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section21
      if (reset == 1'b1) begin
        cic_pipeline21 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline21 <= section_out21;
        end
      end
    end // cic_pipeline_process_section21

  //   ------------------ Section # 22 : Comb ------------------

  assign section_in22 = cic_pipeline21;

  assign section_cast22 = section_in22[29:1];

  assign sub_cast_18 = section_cast22;
  assign sub_cast_19 = diff10;
  assign sub_temp_9 = sub_cast_18 - sub_cast_19;
  assign section_out22 = sub_temp_9[28:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section22
      if (reset == 1'b1) begin
        diff10 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff10 <= section_cast22;
        end
      end
    end // comb_delay_section22

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section22
      if (reset == 1'b1) begin
        cic_pipeline22 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline22 <= section_out22;
        end
      end
    end // cic_pipeline_process_section22

  //   ------------------ Section # 23 : Comb ------------------

  assign section_in23 = cic_pipeline22;

  assign section_cast23 = section_in23[28:1];

  assign sub_cast_20 = section_cast23;
  assign sub_cast_21 = diff11;
  assign sub_temp_10 = sub_cast_20 - sub_cast_21;
  assign section_out23 = sub_temp_10[27:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section23
      if (reset == 1'b1) begin
        diff11 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff11 <= section_cast23;
        end
      end
    end // comb_delay_section23

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section23
      if (reset == 1'b1) begin
        cic_pipeline23 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline23 <= section_out23;
        end
      end
    end // cic_pipeline_process_section23

  //   ------------------ Section # 24 : Comb ------------------

  assign section_in24 = cic_pipeline23;

  assign section_cast24 = section_in24[27:1];

  assign sub_cast_22 = section_cast24;
  assign sub_cast_23 = diff12;
  assign sub_temp_11 = sub_cast_22 - sub_cast_23;
  assign section_out24 = sub_temp_11[26:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section24
      if (reset == 1'b1) begin
        diff12 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff12 <= section_cast24;
        end
      end
    end // comb_delay_section24

  assign output_typeconvert = section_out24[26:3];

  //   ------------------ Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: output_reg_process
      if (reset == 1'b1) begin
        output_register <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          output_register <= output_typeconvert;
        end
      end
    end // output_reg_process

  // Assignment Statements
  assign ce_out = ce_out_reg;
  assign filter_out = output_register;
endmodule  // cic_4_1_12_nofraction
