// -------------------------------------------------------------
//
// Module: cic_10_1_3_nofraction
//
// Generated by MATLAB(R) 7.2 and the Filter Design HDL Coder 1.4.
//
// Generated on: 2007-05-24 16:19:35
//
// -------------------------------------------------------------

// -------------------------------------------------------------
// HDL Code Generation Options:
//
// TargetLanguage: Verilog
// Name: cic_10_1_3_nofraction
// TargetDirectory: c:\HPSDR\trunk\VK6APH\Mercury\Matlab-files
// FIRAdderStyle: tree
// CoeffMultipliers: csd
// SerialPartition: -1
// AddPipelineRegisters: On
// CastBeforeSum: On
//
// Filter Settings:
//
// Discrete-Time FIR Multirate Filter (real)
// -----------------------------------------
// Filter Structure        : Cascaded Integrator-Comb Decimator
// Decimation Factor       : 10
// Differential Delay      : 1
// Number of Sections      : 3
// Stable                  : Yes
// Linear Phase            : Yes (Type 2)
//
// Input                   : s18,0
// Output                  : s24,-4
// Filter Internals        : Minimum Word Lengths
//   Integrator Section 1  : s28,0
//   Integrator Section 2  : s28,0
//   Integrator Section 3  : s28,0
//   Comb Section 1        : s28,0
//   Comb Section 2        : s27,-1
//   Comb Section 3        : s26,-2
//
// Implementation Cost
// Number of Multipliers : 0
// Number of Adders      : 6
// Number of States      : 6
// MultPerInputSample    : 0
// AddPerInputSample     : 3.3
// -------------------------------------------------------------

`timescale 1 ns / 1 ns

module cic_10_1_3_nofraction 
               (
                clk,
                clk_enable,
                reset,
                filter_in,
                filter_out,
                ce_out
                );

  input   clk; 
  input   clk_enable; 
  input   reset; 
  input   signed [17:0] filter_in; //sfix18
  output  signed [23:0] filter_out; //sfix24_E4
  output  ce_out; 

////////////////////////////////////////////////////////////////
//Module Architecture: cic_10_1_3_nofraction
////////////////////////////////////////////////////////////////
  // Local Functions
  // Type Definitions
  // Constants
  // Signals
  reg  [3:0] cur_count; // ufix4
  wire phase_1; // boolean
  wire ce_delayline; // boolean
  reg  int_delay_pipe [0:1] ; // boolean
  wire ce_gated; // boolean
  reg  ce_out_reg; // boolean
  //   
  reg  signed [17:0] input_register; // sfix18
  //   -- Section 1 Signals 
  wire signed [17:0] section_in1; // sfix18
  wire signed [27:0] section_cast1; // sfix28
  wire signed [27:0] sum1; // sfix28
  reg  signed [27:0] section_out1; // sfix28
  wire signed [27:0] add_cast; // sfix28
  wire signed [27:0] add_cast_1; // sfix28
  wire signed [28:0] add_temp; // sfix29
  //   -- Section 2 Signals 
  wire signed [27:0] section_in2; // sfix28
  wire signed [27:0] sum2; // sfix28
  reg  signed [27:0] section_out2; // sfix28
  wire signed [27:0] add_cast_2; // sfix28
  wire signed [27:0] add_cast_3; // sfix28
  wire signed [28:0] add_temp_1; // sfix29
  //   -- Section 3 Signals 
  wire signed [27:0] section_in3; // sfix28
  wire signed [27:0] sum3; // sfix28
  reg  signed [27:0] section_out3; // sfix28
  wire signed [27:0] add_cast_4; // sfix28
  wire signed [27:0] add_cast_5; // sfix28
  wire signed [28:0] add_temp_2; // sfix29
  //   -- Section 4 Signals 
  wire signed [27:0] section_in4; // sfix28
  reg  signed [27:0] diff1; // sfix28
  wire signed [27:0] section_out4; // sfix28
  wire signed [27:0] sub_cast; // sfix28
  wire signed [27:0] sub_cast_1; // sfix28
  wire signed [28:0] sub_temp; // sfix29
  reg  signed [27:0] cic_pipeline4; // sfix28
  //   -- Section 5 Signals 
  wire signed [27:0] section_in5; // sfix28
  wire signed [26:0] section_cast5; // sfix27_E1
  reg  signed [26:0] diff2; // sfix27_E1
  wire signed [26:0] section_out5; // sfix27_E1
  wire signed [26:0] sub_cast_2; // sfix27_E1
  wire signed [26:0] sub_cast_3; // sfix27_E1
  wire signed [27:0] sub_temp_1; // sfix28_E1
  reg  signed [26:0] cic_pipeline5; // sfix27_E1
  //   -- Section 6 Signals 
  wire signed [26:0] section_in6; // sfix27_E1
  wire signed [25:0] section_cast6; // sfix26_E2
  reg  signed [25:0] diff3; // sfix26_E2
  wire signed [25:0] section_out6; // sfix26_E2
  wire signed [25:0] sub_cast_4; // sfix26_E2
  wire signed [25:0] sub_cast_5; // sfix26_E2
  wire signed [26:0] sub_temp_2; // sfix27_E2
  wire signed [23:0] output_typeconvert; // sfix24_E4
  //   
  reg  signed [23:0] output_register; // sfix24_E4

  // Block Statements
  //   ------------------ CE Output Generation ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output
      if (reset == 1'b1) begin
        cur_count <= 4'b0000;
      end
      else begin
        if (clk_enable == 1'b1) begin
          if (cur_count == 4'b1001) begin
            cur_count <= 4'b0000;
          end
          else begin
            cur_count <= cur_count + 1;
          end
        end
      end
    end // ce_output

  assign  phase_1 = (cur_count == 4'b0001 && clk_enable == 1'b1)? 1 : 0;

  always @( posedge clk or posedge reset)
    begin: ce_delay
      if (reset == 1'b1) begin
        int_delay_pipe[0] <= 1'b0;
        int_delay_pipe[1] <= 1'b0;
      end
      else begin
        if (phase_1 == 1'b1) begin
        int_delay_pipe[0] <= clk_enable;
        int_delay_pipe[1] <= int_delay_pipe[0];
        end
      end
    end // ce_delay

    assign ce_delayline = int_delay_pipe[1];
  assign ce_gated =  ce_delayline & phase_1;

  //   ------------------ CE Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: ce_output_register
      if (reset == 1'b1) begin
        ce_out_reg <= 1'b0;
      end
      else begin
          ce_out_reg <= ce_gated;
      end
    end // ce_output_register

  //   ------------------ Input Register ------------------

  always @ (posedge clk or posedge reset)
    begin: input_reg_process
      if (reset == 1'b1) begin
        input_register <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          input_register <= filter_in;
        end
      end
    end // input_reg_process

  //   ------------------ Section # 1 : Integrator ------------------

  assign section_in1 = input_register;

  assign section_cast1 = $signed({{10{section_in1[17]}}, section_in1});

  assign add_cast = section_cast1;
  assign add_cast_1 = section_out1;
  assign add_temp = add_cast + add_cast_1;
  assign sum1 = add_temp[27:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section1
      if (reset == 1'b1) begin
        section_out1 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out1 <= sum1;
        end
      end
    end // integrator_delay_section1

  //   ------------------ Section # 2 : Integrator ------------------

  assign section_in2 = section_out1;

  assign add_cast_2 = section_in2;
  assign add_cast_3 = section_out2;
  assign add_temp_1 = add_cast_2 + add_cast_3;
  assign sum2 = add_temp_1[27:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section2
      if (reset == 1'b1) begin
        section_out2 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out2 <= sum2;
        end
      end
    end // integrator_delay_section2

  //   ------------------ Section # 3 : Integrator ------------------

  assign section_in3 = section_out2;

  assign add_cast_4 = section_in3;
  assign add_cast_5 = section_out3;
  assign add_temp_2 = add_cast_4 + add_cast_5;
  assign sum3 = add_temp_2[27:0];

  always @ (posedge clk or posedge reset)
    begin: integrator_delay_section3
      if (reset == 1'b1) begin
        section_out3 <= 0;
      end
      else begin
        if (clk_enable == 1'b1) begin
          section_out3 <= sum3;
        end
      end
    end // integrator_delay_section3

  //   ------------------ Section # 4 : Comb ------------------

  assign section_in4 = section_out3;

  assign sub_cast = section_in4;
  assign sub_cast_1 = diff1;
  assign sub_temp = sub_cast - sub_cast_1;
  assign section_out4 = sub_temp[27:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section4
      if (reset == 1'b1) begin
        diff1 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff1 <= section_in4;
        end
      end
    end // comb_delay_section4

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section4
      if (reset == 1'b1) begin
        cic_pipeline4 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline4 <= section_out4;
        end
      end
    end // cic_pipeline_process_section4

  //   ------------------ Section # 5 : Comb ------------------

  assign section_in5 = cic_pipeline4;

  assign section_cast5 = section_in5[27:1];

  assign sub_cast_2 = section_cast5;
  assign sub_cast_3 = diff2;
  assign sub_temp_1 = sub_cast_2 - sub_cast_3;
  assign section_out5 = sub_temp_1[26:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section5
      if (reset == 1'b1) begin
        diff2 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff2 <= section_cast5;
        end
      end
    end // comb_delay_section5

  always @ (posedge clk or posedge reset)
    begin: cic_pipeline_process_section5
      if (reset == 1'b1) begin
        cic_pipeline5 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          cic_pipeline5 <= section_out5;
        end
      end
    end // cic_pipeline_process_section5

  //   ------------------ Section # 6 : Comb ------------------

  assign section_in6 = cic_pipeline5;

  assign section_cast6 = section_in6[26:1];

  assign sub_cast_4 = section_cast6;
  assign sub_cast_5 = diff3;
  assign sub_temp_2 = sub_cast_4 - sub_cast_5;
  assign section_out6 = sub_temp_2[25:0];

  always @ (posedge clk or posedge reset)
    begin: comb_delay_section6
      if (reset == 1'b1) begin
        diff3 <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          diff3 <= section_cast6;
        end
      end
    end // comb_delay_section6

  assign output_typeconvert = section_out6[25:2];

  //   ------------------ Output Register ------------------

  always @ (posedge clk or posedge reset)
    begin: output_reg_process
      if (reset == 1'b1) begin
        output_register <= 0;
      end
      else begin
        if (phase_1 == 1'b1) begin
          output_register <= output_typeconvert;
        end
      end
    end // output_reg_process

  // Assignment Statements
  assign ce_out = ce_out_reg;
  assign filter_out = output_register;
endmodule  // cic_10_1_3_nofraction
